/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionBasedActionHandler;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.ProcessorIssue;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.api.model.config.btxn.SetDetailAction;

public class SetDetailActionHandler
extends ExpressionBasedActionHandler {
    private static final String NAME_MUST_BE_SPECIFIED = "Name must be specified";

    public SetDetailActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        SetDetailAction action = (SetDetailAction)this.getAction();
        if (action.getName() == null || action.getName().trim().length() == 0) {
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("name");
            pi.setSeverity(Severity.Error);
            pi.setDescription(NAME_MUST_BE_SPECIFIED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(0, pi);
        }
    }

    @Override
    public boolean process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(btxn, node, direction, headers, values) && (value = this.getValue(btxn, node, direction, headers, values)) != null && ((SetDetailAction)this.getAction()).getName() != null) {
            node.getDetails().put(((SetDetailAction)this.getAction()).getName(), value);
            return true;
        }
        return false;
    }
}

