/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionBasedActionHandler;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.Message;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.ProcessorIssue;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.AddContentAction;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;

public class AddContentActionHandler
extends ExpressionBasedActionHandler {
    private static final Logger log = Logger.getLogger(AddContentActionHandler.class.getName());
    private static final String NAME_MUST_BE_SPECIFIED = "Name must be specified";

    public AddContentActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        AddContentAction action = (AddContentAction)this.getAction();
        if (action.getName() == null || action.getName().trim().length() == 0) {
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("name");
            pi.setSeverity(Severity.Error);
            pi.setDescription(NAME_MUST_BE_SPECIFIED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(0, pi);
        }
    }

    @Override
    public boolean process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(btxn, node, direction, headers, values) && (value = this.getValue(btxn, node, direction, headers, values)) != null) {
            if (node.interactionNode()) {
                if (direction == Direction.In) {
                    if (((InteractionNode)node).getIn() == null) {
                        ((InteractionNode)node).setIn(new Message());
                    }
                    ((InteractionNode)node).getIn().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                } else {
                    if (((InteractionNode)node).getOut() == null) {
                        ((InteractionNode)node).setOut(new Message());
                    }
                    ((InteractionNode)node).getOut().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                }
                return true;
            }
            log.warning("Attempt to add content to a non-interaction based node type '" + (Object)((Object)node.getType()) + "'");
        }
        return false;
    }
}

