/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.hawkular.btm.api.internal.actions.ProcessorActionHandler;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.ProcessorIssue;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.EvaluateURIAction;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.api.utils.NodeUtil;

public class EvaluateURIActionHandler
extends ProcessorActionHandler {
    private static final Logger log = Logger.getLogger(EvaluateURIActionHandler.class.getName());
    public static final String TEMPLATE_MUST_BE_SPECIFIED = "Template must be specified";
    private String pathTemplate;
    private List<String> queryParameters = new ArrayList<String>();

    public EvaluateURIActionHandler(ProcessorAction action) {
        super(action);
        this.pathTemplate = ((EvaluateURIAction)this.getAction()).getTemplate();
        if (this.pathTemplate != null && this.pathTemplate.indexOf(63) != -1) {
            int index = this.pathTemplate.indexOf(63);
            String queryString = this.pathTemplate.substring(index + 1);
            this.pathTemplate = this.pathTemplate.substring(0, index);
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}') {
                    this.queryParameters.add(token.substring(1, token.length() - 1));
                    continue;
                }
                log.severe("Expecting query parameter template, e.g. {name}, but got '" + token + "'");
            }
        }
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        EvaluateURIAction action = (EvaluateURIAction)this.getAction();
        if (action.getTemplate() == null || action.getTemplate().trim().length() == 0) {
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("template");
            pi.setSeverity(Severity.Error);
            pi.setDescription(TEMPLATE_MUST_BE_SPECIFIED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(0, pi);
        }
    }

    @Override
    public boolean process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (super.process(btxn, node, direction, headers, values) && node.getUri() != null && this.pathTemplate != null) {
            StringTokenizer uriTokens = new StringTokenizer(node.getUri(), "/");
            StringTokenizer templateTokens = new StringTokenizer(this.pathTemplate, "/");
            if (uriTokens.countTokens() == templateTokens.countTokens()) {
                HashMap<String, String> props = null;
                while (uriTokens.hasMoreTokens()) {
                    String uriToken = uriTokens.nextToken();
                    String templateToken = templateTokens.nextToken();
                    if (templateToken.charAt(0) == '{' && templateToken.charAt(templateToken.length() - 1) == '}') {
                        String name = templateToken.substring(1, templateToken.length() - 1);
                        if (props == null) {
                            props = new HashMap<String, String>();
                        }
                        try {
                            props.put(name, URLDecoder.decode(uriToken, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isLoggable(Logger.Level.FINEST)) continue;
                            log.finest("Failed to decode value '" + uriToken + "': " + e);
                        }
                        continue;
                    }
                    if (uriToken.equals(templateToken)) continue;
                    return false;
                }
                boolean processed = false;
                if (props != null) {
                    btxn.getProperties().putAll(props);
                    NodeUtil.rewriteURI(node, this.pathTemplate);
                    processed = true;
                }
                if (!this.queryParameters.isEmpty() && this.processQueryParameters(btxn, node)) {
                    processed = true;
                }
                return processed;
            }
        }
        return false;
    }

    protected boolean processQueryParameters(BusinessTransaction btxn, Node node) {
        boolean ret = false;
        String queryString = node.getDetails().get("http_query");
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] namevalue = token.split("=");
                if (namevalue.length == 2) {
                    if (this.queryParameters.contains(namevalue[0])) {
                        try {
                            btxn.getProperties().put(namevalue[0], URLDecoder.decode(namevalue[1], "UTF-8"));
                            ret = true;
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isLoggable(Logger.Level.FINEST)) continue;
                            log.finest("Failed to decode value '" + namevalue[1] + "': " + e);
                        }
                        continue;
                    }
                    if (!log.isLoggable(Logger.Level.FINEST)) continue;
                    log.finest("Ignoring query parameter '" + namevalue[0] + "'");
                    continue;
                }
                if (!log.isLoggable(Logger.Level.FINEST)) continue;
                log.finest("Query string part does not include name/value pair: " + token);
            }
        }
        return ret;
    }
}

