/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionHandler;
import org.hawkular.btm.api.internal.actions.ExpressionHandlerFactory;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.ProcessorIssue;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;

public abstract class ProcessorActionHandler {
    private static final Logger log = Logger.getLogger(ProcessorActionHandler.class.getName());
    private ProcessorAction action;
    private ExpressionHandler predicate;
    private boolean usesHeaders = false;
    private boolean usesContent = false;
    private List<Issue> issues;

    public ProcessorActionHandler(ProcessorAction action) {
        this.setAction(action);
    }

    public ProcessorAction getAction() {
        return this.action;
    }

    protected void setAction(ProcessorAction action) {
        this.action = action;
    }

    public boolean isUsesHeaders() {
        return this.usesHeaders;
    }

    public void setUsesHeaders(boolean usesHeaders) {
        this.usesHeaders = usesHeaders;
    }

    public boolean isUsesContent() {
        return this.usesContent;
    }

    public void setUsesContent(boolean usesContent) {
        this.usesContent = usesContent;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    public void init(Processor processor) {
        if (this.action.getPredicate() != null) {
            try {
                this.predicate = ExpressionHandlerFactory.getHandler(this.action.getPredicate());
                this.predicate.init(processor, this.getAction(), true);
                if (!this.isUsesHeaders()) {
                    this.setUsesHeaders(this.predicate.isUsesHeaders());
                }
                if (!this.isUsesContent()) {
                    this.setUsesContent(this.predicate.isUsesContent());
                }
            }
            catch (Throwable t) {
                if (log.isLoggable(Logger.Level.FINE)) {
                    log.log(Logger.Level.FINE, "Failed to initialise predicate for action '" + this.action + "'", t);
                }
                ProcessorIssue pi = new ProcessorIssue();
                pi.setProcessor(processor.getDescription());
                pi.setAction(this.action.getDescription());
                pi.setSeverity(Severity.Error);
                pi.setDescription(t.getMessage());
                if (this.issues == null) {
                    this.issues = new ArrayList<Issue>();
                }
                this.issues.add(pi);
            }
        }
    }

    public boolean process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.issues != null) {
            node.getIssues().addAll(this.issues);
        }
        if (this.predicate != null) {
            return this.predicate.test(btxn, node, direction, headers, values);
        }
        return true;
    }
}

