/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;

public class Criteria {
    private final Logger log = Logger.getLogger(Criteria.class.getName());
    private long startTime = 0L;
    private long endTime = 0L;
    private String businessTransaction;
    private Set<PropertyCriteria> properties = new HashSet<PropertyCriteria>();
    private Set<CorrelationIdentifier> correlationIds = new HashSet<CorrelationIdentifier>();
    private Set<FaultCriteria> faults = new HashSet<FaultCriteria>();
    private String hostName;
    private long upperBound;
    private long lowerBound;
    private String principal;
    private static int DEFAULT_RESPONSE_SIZE = 100000;
    private static long DEFAULT_TIMEOUT = 10000L;
    private long timeout = DEFAULT_TIMEOUT;
    private int maxResponseSize = DEFAULT_RESPONSE_SIZE;

    public long getStartTime() {
        return this.startTime;
    }

    public Criteria setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long calculateStartTime() {
        if (this.startTime == 0L) {
            return this.calculateEndTime() - 3600000L;
        }
        if (this.startTime < 0L) {
            return this.calculateEndTime() + this.startTime;
        }
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Criteria setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public long calculateEndTime() {
        if (this.endTime == 0L) {
            return System.currentTimeMillis();
        }
        if (this.endTime < 0L) {
            return System.currentTimeMillis() - this.endTime;
        }
        return this.endTime;
    }

    public String getBusinessTransaction() {
        return this.businessTransaction;
    }

    public Criteria setBusinessTransaction(String name) {
        this.businessTransaction = name;
        return this;
    }

    public Set<PropertyCriteria> getProperties() {
        return this.properties;
    }

    public Criteria setProperties(Set<PropertyCriteria> properties) {
        this.properties = properties;
        return this;
    }

    public void addProperty(String name, String value, boolean excluded) {
        this.properties.add(new PropertyCriteria(name, value, excluded));
    }

    public Set<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public Criteria setCorrelationIds(Set<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Criteria setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Criteria setPrincipal(String principal) {
        this.principal = principal;
        return this;
    }

    public Set<FaultCriteria> getFaults() {
        return this.faults;
    }

    public Criteria setFaults(Set<FaultCriteria> faults) {
        this.faults = faults;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public Map<String, String> parameters() {
        StringBuilder buf;
        boolean first;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.getBusinessTransaction() != null) {
            ret.put("businessTransaction", this.getBusinessTransaction());
        }
        if (this.getStartTime() > 0L) {
            ret.put("startTime", "" + this.getStartTime());
        }
        if (this.getEndTime() > 0L) {
            ret.put("endTime", "" + this.getEndTime());
        }
        if (!this.getProperties().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (PropertyCriteria propertyCriteria : this.getProperties()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(propertyCriteria.encoded());
            }
            ret.put("properties", buf.toString());
        }
        if (this.hostName != null) {
            ret.put("hostName", this.hostName);
        }
        if (!this.getCorrelationIds().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (CorrelationIdentifier correlationIdentifier : this.getCorrelationIds()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(correlationIdentifier.getScope().name());
                buf.append('|');
                buf.append(correlationIdentifier.getValue());
            }
            ret.put("correlations", buf.toString());
        }
        if (!this.getFaults().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (FaultCriteria faultCriteria : this.getFaults()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(faultCriteria.encoded());
            }
            ret.put("faults", buf.toString());
        }
        if (this.principal != null) {
            ret.put("principal", this.principal);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Criteria parameters [" + ret + "]");
        }
        return ret;
    }

    public boolean transactionWide() {
        return this.properties.size() <= 0 && this.correlationIds.size() <= 0 && this.faults.size() <= 0 && this.hostName == null;
    }

    public Criteria deriveTransactionWide() {
        Criteria ret = new Criteria();
        ret.setStartTime(this.startTime);
        ret.setEndTime(this.endTime);
        ret.setBusinessTransaction(this.businessTransaction);
        ret.setPrincipal(this.principal);
        return ret;
    }

    public String toString() {
        return "Criteria [startTime=" + this.startTime + ", endTime=" + this.endTime + ", businessTransaction=" + this.businessTransaction + ", properties=" + this.properties + ", correlationIds=" + this.correlationIds + ", faults=" + this.faults + ", hostName=" + this.hostName + ", upperBound=" + this.upperBound + ", lowerBound=" + this.lowerBound + ", principal=" + this.principal + ", timeout=" + this.timeout + ", maxResponseSize=" + this.maxResponseSize + "]";
    }

    public static class FaultCriteria {
        private String value;
        private boolean excluded = false;

        public FaultCriteria() {
        }

        public FaultCriteria(String value, boolean excluded) {
            this.value = value;
            this.excluded = excluded;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        public String encoded() {
            StringBuilder buf = new StringBuilder();
            if (this.isExcluded()) {
                buf.append('-');
            }
            buf.append(this.getValue());
            return buf.toString();
        }

        public String toString() {
            return "FaultCriteria [value=" + this.value + ", excluded=" + this.excluded + "]";
        }
    }

    public static class PropertyCriteria {
        private String name;
        private String value;
        private boolean excluded = false;

        public PropertyCriteria() {
        }

        public PropertyCriteria(String name, String value, boolean excluded) {
            this.name = name;
            this.value = value;
            this.excluded = excluded;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        public String encoded() {
            StringBuilder buf = new StringBuilder();
            if (this.isExcluded()) {
                buf.append('-');
            }
            buf.append(this.getName());
            buf.append('|');
            buf.append(this.getValue());
            return buf.toString();
        }

        public String toString() {
            return "PropertyCriteria [name=" + this.name + ", value=" + this.value + ", excluded=" + this.excluded + "]";
        }
    }
}

