/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.btm.api.client.Logger;
import org.hawkular.btm.client.collector.internal.FragmentBuilder;

public class FragmentManager {
    private static final Logger log = Logger.getLogger((String)FragmentManager.class.getName());
    private ThreadLocal<FragmentBuilder> builders = new ThreadLocal();
    private AtomicInteger threadCounter = new AtomicInteger();

    protected int getThreadCounter() {
        return this.threadCounter.get();
    }

    public boolean hasFragmentBuilder() {
        return this.builders.get() != null;
    }

    public FragmentBuilder getFragmentBuilder() {
        FragmentBuilder builder = this.builders.get();
        if (builder == null) {
            builder = new FragmentBuilder();
            this.builders.set(builder);
            int currentCount = this.threadCounter.incrementAndGet();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Associate Thread with FragmentBuilder(1): current count=" + currentCount);
            }
        }
        return builder;
    }

    public void setFragmentBuilder(FragmentBuilder builder) {
        FragmentBuilder currentBuilder = this.builders.get();
        if (currentBuilder == null && builder != null) {
            int currentCount = this.threadCounter.incrementAndGet();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Associate Thread with FragmentBuilder(2): current count=" + currentCount);
            }
        } else if (currentBuilder != null && builder == null) {
            int currentCount = this.threadCounter.decrementAndGet();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Disassociate Thread from FragmentBuilder(2): current count=" + currentCount);
            }
        }
        this.builders.set(builder);
    }

    public void clear() {
        int currentCount = this.threadCounter.decrementAndGet();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Disassociate Thread from FragmentBuilder(1): current count=" + currentCount);
        }
        this.builders.remove();
    }
}

