/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.admin.CollectorConfiguration;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Component;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Message;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.btxn.Service;
import org.hawkular.btm.api.services.AdminService;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.api.services.ServiceResolver;
import org.hawkular.btm.client.api.BusinessTransactionCollector;
import org.hawkular.btm.client.api.SessionManager;
import org.hawkular.btm.client.collector.internal.BusinessTransactionReporter;
import org.hawkular.btm.client.collector.internal.FilterManager;
import org.hawkular.btm.client.collector.internal.FragmentBuilder;
import org.hawkular.btm.client.collector.internal.FragmentManager;

public class DefaultBusinessTransactionCollector
implements BusinessTransactionCollector,
SessionManager {
    private static final Logger log = Logger.getLogger((String)DefaultBusinessTransactionCollector.class.getName());
    private FragmentManager fragmentManager = new FragmentManager();
    private FilterManager filterManager;
    private BusinessTransactionReporter reporter = new BusinessTransactionReporter();
    private Map<String, FragmentBuilder> links = new ConcurrentHashMap<String, FragmentBuilder>();
    private static final Logger.Level warningLogLevel = Logger.Level.WARNING;

    public DefaultBusinessTransactionCollector() {
        CompletableFuture asFuture = ServiceResolver.getSingletonService(AdminService.class);
        asFuture.whenComplete(new BiConsumer<AdminService, Throwable>(){

            @Override
            public void accept(AdminService as, Throwable t) {
                DefaultBusinessTransactionCollector.this.setAdminService(as);
            }
        });
    }

    public void setAdminService(AdminService as) {
        CollectorConfiguration config = as.getConfiguration(null, null, null);
        if (config != null) {
            this.filterManager = new FilterManager(config);
            this.reporter.init(config);
        }
    }

    public BusinessTransactionService getBusinessTransactionService() {
        return this.reporter.getBusinessTransactionService();
    }

    public void setBusinessTransactionService(BusinessTransactionService businessTransactionService) {
        this.reporter.setBusinessTransactionService(businessTransactionService);
    }

    public String getTenantId() {
        return this.reporter.getTenantId();
    }

    public void setTenantId(String tenantId) {
        this.reporter.setTenantId(tenantId);
    }

    public void setName(String name) {
        block8: {
            if (name == null || name.trim().isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Ignoring attempt to set business transaction name to null");
                }
                return;
            }
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set business transaction name=" + name);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getBusinessTransaction().setName(name);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block8;
                log.log(warningLogLevel, "setName failed", t);
            }
        }
    }

    public String getName() {
        String ret;
        block7: {
            ret = null;
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    ret = builder.getBusinessTransaction().getName();
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "getName failed", t);
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction name=" + ret);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void consumerStart(String uri, String type, String id, Map<String, ?> headers, Object ... values) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Consumer start: type=" + type + " uri=" + uri + " id=" + id + " headers=" + headers + " values=" + values);
            }
            try {
                Consumer consumer = new Consumer();
                consumer.setEndpointType(type);
                consumer.setUri(uri);
                this.processValues((InteractionNode)consumer, true, id, headers, values);
                this.push((Node)consumer);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "consumerStart failed", t);
            }
        }
    }

    public void consumerEnd(String uri, String type, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Consumer end: type=" + type + " uri=" + uri + " headers=" + headers + " values=" + values);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Consumer consumer = this.pop(builder, Consumer.class, uri);
                    this.processValues((InteractionNode)consumer, false, null, headers, values);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "consumerEnd failed", t);
            }
        }
    }

    public void serviceStart(String uri, String operation, Map<String, ?> headers, Object ... values) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Service start: uri=" + uri + " operation=" + operation + " values=" + values);
            }
            try {
                Service service = new Service();
                service.setUri(uri);
                service.setOperation(operation);
                this.processValues((InteractionNode)service, true, null, headers, values);
                this.push((Node)service);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "serviceStart failed", t);
            }
        }
    }

    public void serviceEnd(String uri, String operation, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Service end: uri=" + uri + " operation=" + operation + " values=" + values);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Service service = this.pop(builder, Service.class, uri);
                    this.processValues((InteractionNode)service, false, null, headers, values);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "serviceEnd failed", t);
            }
        }
    }

    public void componentStart(String uri, String type, String operation) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Component start: type=" + type + " operation=" + operation + " uri=" + uri);
            }
            try {
                Component component = new Component();
                component.setComponentType(type);
                component.setUri(uri);
                component.setOperation(operation);
                this.push((Node)component);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "componentStart failed", t);
            }
        }
    }

    public void componentEnd(String uri, String type, String operation) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Component end: type=" + type + " operation=" + operation + " uri=" + uri);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    this.pop(builder, Component.class, uri);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "componentEnd failed", t);
            }
        }
    }

    public void producerStart(String uri, String type, String id, Map<String, ?> headers, Object ... values) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Producer start: type=" + type + " uri=" + uri + " id=" + id + " headers=" + headers + " values=" + values);
            }
            try {
                Producer producer = new Producer();
                producer.setEndpointType(type);
                producer.setUri(uri);
                this.processValues((InteractionNode)producer, true, id, headers, values);
                this.push((Node)producer);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "producerStart failed", t);
            }
        }
    }

    public void producerEnd(String uri, String type, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Producer end: type=" + type + " uri=" + uri + " headers=" + headers + " values=" + values);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Producer producer = this.pop(builder, Producer.class, uri);
                    this.processValues((InteractionNode)producer, false, null, headers, values);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "producerEnd failed", t);
            }
        }
    }

    public void setProperty(String name, String value) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set business transaction property: name=" + name + " value=" + value);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getBusinessTransaction().getProperties().put(name, value);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "setProperty failed", t);
            }
        }
    }

    public void setDetail(String name, String value) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set node detail: name=" + name + " value=" + value);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getCurrentNode().getDetails().put(name, value);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "setDetail failed", t);
            }
        }
    }

    protected void push(Node node) {
        FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
        if (builder != null) {
            node.setStartTime(System.currentTimeMillis());
            builder.pushNode(node);
        }
    }

    protected <T extends Node> T pop(FragmentBuilder builder, Class<T> cls, String uri) {
        if (builder == null) {
            if (log.isLoggable(Logger.Level.WARNING)) {
                log.warning("No fragment builder for this thread (" + Thread.currentThread() + ") - trying to pop node of type: " + cls);
            }
            return null;
        }
        if (builder.getCurrentNode() == null) {
            if (log.isLoggable(Logger.Level.WARNING)) {
                log.warning("No 'current node' for this thread (" + Thread.currentThread() + ") - trying to pop node of type: " + cls);
            }
            return null;
        }
        Node node = builder.popNode(cls, uri);
        if (node != null) {
            node.setDuration(System.currentTimeMillis() - node.getStartTime());
            return (T)((Node)cls.cast(node));
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Current node (type=" + builder.getCurrentNode().getClass() + ") does not match required cls=" + cls + "and uri=" + uri);
        }
        return null;
    }

    protected void processValues(InteractionNode node, boolean req, String id, Map<String, ?> headers, Object[] values) {
        Message m = new Message();
        m.setId(id);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                m.getParameters().add(values[i].toString());
            }
        }
        if (id != null && req) {
            node.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                String value = this.getHeaderValueText(headers.get(key));
                if (value == null) continue;
                m.getHeaders().put(key, value);
            }
        }
        if (req) {
            node.setRequest(m);
        } else {
            node.setResponse(m);
        }
    }

    protected String getHeaderValueText(Object value) {
        if (value.getClass() == String.class) {
            return (String)value;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 1) {
                return this.getHeaderValueText(list.get(0));
            }
            return list.toString();
        }
        return null;
    }

    protected void checkForCompletion(FragmentBuilder builder) {
        if (builder.isComplete()) {
            BusinessTransaction btxn = builder.getBusinessTransaction();
            if (btxn != null && !btxn.getNodes().isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Record business transaction: " + btxn);
                }
                this.reporter.report(btxn);
            }
            this.fragmentManager.clear();
            this.diagnostics();
        }
    }

    public boolean activate(String uri) {
        return this.activate(uri, null);
    }

    public boolean activate(String uri, String id) {
        if (this.isActive()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("activate: Already active");
            }
            return true;
        }
        if (id != null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("activate: ID not null, so fragment will be traced");
            }
            return true;
        }
        if (uri != null) {
            if (this.filterManager == null) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Unable to determine if fragment should be traced due to missing filter manager");
                }
            } else {
                FragmentBuilder builder;
                String btxnName = this.filterManager.getBusinessTransactionName(uri);
                if (btxnName != null && !btxnName.trim().isEmpty() && (builder = this.fragmentManager.getFragmentBuilder()) != null) {
                    builder.getBusinessTransaction().setName(btxnName);
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("activate: URI[" + uri + "] business transaction name=" + btxnName);
                }
                return btxnName != null;
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("activate: No URI, so returning false");
        }
        return false;
    }

    public boolean isActive() {
        try {
            return this.fragmentManager.hasFragmentBuilder();
        }
        catch (Throwable t) {
            if (log.isLoggable(warningLogLevel)) {
                log.log(warningLogLevel, "isActive failed", t);
            }
            return false;
        }
    }

    public void retainNode(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Retain node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.retainNode(id);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "retainNode failed", t);
            }
        }
    }

    public void releaseNode(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Release node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.releaseNode(id);
                    this.checkForCompletion(builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "releaseNode failed", t);
            }
        }
    }

    public Node retrieveNode(String id) {
        Node ret;
        block4: {
            ret = null;
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Retrieve node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    ret = builder.retrieveNode(id);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "retrieveNode failed", t);
            }
        }
        return ret;
    }

    public void initiateLink(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Initiate link: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getUnlinkedIds().add(id);
                    this.links.put(id, builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "initiateLink failed", t);
            }
        }
    }

    public boolean isLinkActive(String id) {
        boolean linkActive = this.links.containsKey(id);
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Is link active? id=" + id + " result=" + linkActive);
        }
        return linkActive;
    }

    public void completeLink(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Complete link: id=" + id);
            }
            try {
                FragmentBuilder builder = this.links.get(id);
                if (builder != null) {
                    builder.getUnlinkedIds().remove(id);
                    this.links.remove(id);
                    this.fragmentManager.setFragmentBuilder(builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "completeLink failed", t);
            }
        }
    }

    public void unlink() {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Unlink");
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    this.fragmentManager.clear();
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "unlink failed", t);
            }
        }
    }

    public void suppress() {
        FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
        if (builder != null) {
            builder.suppress();
        }
    }

    public void assertComplete() {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Assert complete");
            }
            try {
                FragmentBuilder builder;
                if (this.fragmentManager.hasFragmentBuilder() && !(builder = this.fragmentManager.getFragmentBuilder()).isComplete()) {
                    log.severe("Business transaction has not completed: " + this.fragmentManager.getFragmentBuilder());
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "assertComplete failed", t);
            }
        }
    }

    public SessionManager session() {
        return this;
    }

    protected FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    protected void diagnostics() {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            log.finest("BTM COLLECTOR DIAGNOSTICS:");
            this.fragmentManager.diagnostics();
            log.finest("Links (" + this.links.size() + "): " + this.links);
            log.finest("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }
}

