/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.Node;

public class FragmentBuilder {
    private static final Logger log = Logger.getLogger((String)FragmentBuilder.class.getName());
    private BusinessTransaction businessTransaction;
    private Stack<Node> nodeStack = new Stack();
    private Stack<Node> suppressedNodeStack = new Stack();
    private Map<String, Node> retainedNodes = new HashMap<String, Node>();
    private List<String> unlinkedIds = new ArrayList<String>();
    private boolean suppress = false;
    private static String hostName;
    private static String hostAddress;

    public FragmentBuilder() {
        this.businessTransaction = new BusinessTransaction().setId(UUID.randomUUID().toString()).setHostName(hostName).setHostAddress(hostAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            return this.nodeStack.isEmpty() && this.retainedNodes.isEmpty();
        }
    }

    public BusinessTransaction getBusinessTransaction() {
        return this.businessTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getCurrentNode() {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            return this.nodeStack.isEmpty() ? null : this.nodeStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushNode(Node node) {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            if (this.suppress) {
                this.suppressedNodeStack.push(node);
                return;
            }
            if (this.nodeStack.isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Pushing top level node: " + node + " for txn: " + this.businessTransaction);
                }
                this.businessTransaction.getNodes().add(node);
            } else {
                Node parent = this.nodeStack.peek();
                if (parent instanceof ContainerNode) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Add node: " + node + " to parent: " + parent + " in txn: " + this.businessTransaction);
                    }
                    ((ContainerNode)parent).getNodes().add(node);
                } else {
                    log.severe("Attempt to add node '" + node + "' under non-container node '" + parent + "'");
                }
            }
            this.nodeStack.push(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node popNode(Class<? extends Node> cls, String uri) {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            if (this.suppress) {
                if (!this.suppressedNodeStack.isEmpty()) {
                    Node suppressed = this.popNode(this.suppressedNodeStack, cls, uri);
                    if (suppressed != null) {
                        return suppressed;
                    }
                } else {
                    this.suppress = false;
                }
            }
            return this.popNode(this.nodeStack, cls, uri);
        }
    }

    protected Node popNode(Stack<Node> stack, Class<? extends Node> cls, String uri) {
        Node top;
        Node node = top = stack.isEmpty() ? null : stack.peek();
        if (top != null) {
            if (this.nodeMatches(top, cls, uri)) {
                return stack.pop();
            }
            for (int i = stack.size() - 2; i >= 0; --i) {
                if (!this.nodeMatches((Node)stack.get(i), cls, uri)) continue;
                return (Node)stack.remove(i);
            }
        }
        return null;
    }

    protected boolean nodeMatches(Node node, Class<? extends Node> cls, String uri) {
        if (node.getClass() == cls) {
            return uri == null || uri.equals(node.getUri());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            Node current = this.getCurrentNode();
            if (current != null) {
                this.retainedNodes.put(id, current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            this.retainedNodes.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node retrieveNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            return this.retainedNodes.get(id);
        }
    }

    public List<String> getUnlinkedIds() {
        return this.unlinkedIds;
    }

    public void suppress() {
        this.suppress = true;
    }

    public boolean isSuppressed() {
        return this.suppress;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("Fragment builder: current btxn=[");
        info.append(this.businessTransaction);
        info.append("] complete=");
        info.append(this.isComplete());
        info.append(" unlinkedIds=");
        info.append(this.getUnlinkedIds());
        info.append(" stack=");
        info.append(this.nodeStack);
        return info.toString();
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.severe("Unable to determine host name");
        }
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.severe("Unable to determine host address");
        }
    }
}

