/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.admin.CollectorConfiguration;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.api.services.ServiceResolver;

public class BusinessTransactionReporter {
    private static final int DEFAULT_BATCH_THREAD_POOL_SIZE = 5;
    private static final String HAWKULAR_BTM_TENANT_ID = "hawkular-btm.tenantId";
    private static final Logger log = Logger.getLogger((String)BusinessTransactionReporter.class.getName());
    private static final int DEFAULT_BATCH_TIME = 500;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private BusinessTransactionService businessTransactionService;
    private int batchSize = 1000;
    private int batchTime = 500;
    private String tenantId = System.getProperty("hawkular-btm.tenantId");
    private ExecutorService executor = Executors.newFixedThreadPool(5);
    private final ReentrantLock lock = new ReentrantLock();
    private List<BusinessTransaction> businessTxns = new ArrayList<BusinessTransaction>();

    public BusinessTransactionReporter() {
        CompletableFuture bts = ServiceResolver.getSingletonService(BusinessTransactionService.class);
        bts.whenCompleteAsync(new BiConsumer<BusinessTransactionService, Throwable>(){

            @Override
            public void accept(BusinessTransactionService arg0, Throwable arg1) {
                if (BusinessTransactionReporter.this.businessTransactionService == null) {
                    BusinessTransactionReporter.this.setBusinessTransactionService(arg0);
                    if (arg1 != null) {
                        log.severe("Failed to locate Business Transaction Service: " + arg1);
                    } else {
                        log.info("Initialised Business Transaction Service: " + arg0 + " in this=" + this);
                    }
                }
            }
        });
    }

    public void setBusinessTransactionService(BusinessTransactionService bts) {
        this.businessTransactionService = bts;
    }

    public BusinessTransactionService getBusinessTransactionService() {
        return this.businessTransactionService;
    }

    public void init(CollectorConfiguration config) {
        if (config != null) {
            String time;
            String size;
            if (log.isLoggable(Logger.Level.FINE)) {
                log.fine("Initializing BusinessTransactionReporter with collector configuration");
            }
            if ((size = config.getProperty("hawkular-btm.collector.batchsize", null)) != null) {
                this.batchSize = Integer.parseInt(size);
            }
            if ((time = config.getProperty("hawkular-btm.collector.batchtime", null)) != null) {
                this.batchTime = Integer.parseInt(time);
            }
            this.tenantId = config.getProperty(HAWKULAR_BTM_TENANT_ID, null);
            String pool = config.getProperty("hawkular-btm.collector.batchthreads", null);
            if (pool != null) {
                this.executor = Executors.newFixedThreadPool(Integer.parseInt(pool));
            }
        }
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (BusinessTransactionReporter.this.businessTxns.size() > 0) {
                    try {
                        BusinessTransactionReporter.this.lock.lock();
                        BusinessTransactionReporter.this.submitBusinessTransactions();
                    }
                    finally {
                        BusinessTransactionReporter.this.lock.unlock();
                    }
                }
            }
        }, this.batchTime, this.batchTime, TimeUnit.MILLISECONDS);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void report(BusinessTransaction btxn) {
        if (this.businessTransactionService != null) {
            try {
                this.lock.lock();
                this.businessTxns.add(btxn);
                if (this.businessTxns.size() < this.batchSize) return;
                this.submitBusinessTransactions();
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            log.warning("Business transaction service is not available!");
        }
    }

    protected void submitBusinessTransactions() {
        if (this.businessTxns.size() > 0) {
            final List<BusinessTransaction> toSend = this.businessTxns;
            this.businessTxns = new ArrayList<BusinessTransaction>();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BusinessTransactionReporter.this.businessTransactionService.store(BusinessTransactionReporter.this.tenantId, toSend);
                    }
                    catch (Exception e) {
                        log.log(Logger.Level.SEVERE, "Failed to store business transactions", (Throwable)e);
                    }
                }
            });
        }
    }
}

