/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hawkular.btm.api.model.admin.Filter;

public class FilterProcessor {
    private String businessTransaction;
    private Filter filter;
    private List<Predicate<String>> inclusions = new ArrayList<Predicate<String>>();
    private List<Predicate<String>> exclusions = new ArrayList<Predicate<String>>();

    public FilterProcessor(String btxn, Filter filter) {
        this.setBusinessTransaction(btxn);
        this.setFilter(filter);
        this.init();
    }

    protected void init() {
        int i;
        for (i = 0; i < this.filter.getInclusions().size(); ++i) {
            this.inclusions.add(Pattern.compile((String)this.filter.getInclusions().get(i)).asPredicate());
        }
        for (i = 0; i < this.filter.getExclusions().size(); ++i) {
            this.exclusions.add(Pattern.compile((String)this.filter.getExclusions().get(i)).asPredicate());
        }
    }

    public String getBusinessTransaction() {
        return this.businessTransaction;
    }

    public void setBusinessTransaction(String businessTransaction) {
        this.businessTransaction = businessTransaction;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean isIncludeAll() {
        return this.inclusions.isEmpty();
    }

    public boolean isIncluded(String uri) {
        for (int i = 0; i < this.inclusions.size(); ++i) {
            if (!this.inclusions.get(i).test(uri)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(String uri) {
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!this.exclusions.get(i).test(uri)) continue;
            return true;
        }
        return false;
    }
}

