/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.services.BusinessTransactionPublisher;
import org.hawkular.btm.api.services.ServiceResolver;

public class BusinessTransactionReporter {
    private static final int DEFAULT_BATCH_THREAD_POOL_SIZE = 5;
    private static final String HAWKULAR_BTM_TENANT_ID = "hawkular-btm.tenantId";
    private static final Logger log = Logger.getLogger((String)BusinessTransactionReporter.class.getName());
    private static final int DEFAULT_BATCH_TIME = 500;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private BusinessTransactionPublisher businessTransactionPublisher;
    private int batchSize = 1000;
    private int batchTime = 500;
    private String tenantId = System.getProperty("hawkular-btm.tenantId");
    private ExecutorService executor = Executors.newFixedThreadPool(5);
    private final ReentrantLock lock = new ReentrantLock();
    private List<BusinessTransaction> businessTxns = new ArrayList<BusinessTransaction>();

    public BusinessTransactionReporter() {
        CompletableFuture bts = ServiceResolver.getSingletonService(BusinessTransactionPublisher.class);
        bts.whenCompleteAsync(new BiConsumer<BusinessTransactionPublisher, Throwable>(){

            @Override
            public void accept(BusinessTransactionPublisher arg0, Throwable arg1) {
                if (BusinessTransactionReporter.this.businessTransactionPublisher == null) {
                    BusinessTransactionReporter.this.setBusinessTransactionPublisher(arg0);
                    if (arg1 != null) {
                        log.severe("Failed to locate Business Transaction Publisher: " + arg1);
                    } else {
                        log.info("Initialised Business Transaction Publisher: " + arg0 + " in this=" + this);
                    }
                }
            }
        });
    }

    public void setBusinessTransactionPublisher(BusinessTransactionPublisher btp) {
        this.businessTransactionPublisher = btp;
    }

    public BusinessTransactionPublisher getBusinessTransactionPublisher() {
        return this.businessTransactionPublisher;
    }

    public void init(CollectorConfiguration config) {
        if (config != null) {
            String time;
            String size;
            if (log.isLoggable(Logger.Level.FINE)) {
                log.fine("Initializing BusinessTransactionReporter with collector configuration");
            }
            if ((size = config.getProperty("hawkular-btm.collector.batchsize", null)) != null) {
                this.batchSize = Integer.parseInt(size);
            }
            if ((time = config.getProperty("hawkular-btm.collector.batchtime", null)) != null) {
                this.batchTime = Integer.parseInt(time);
            }
            this.tenantId = config.getProperty(HAWKULAR_BTM_TENANT_ID, null);
            String pool = config.getProperty("hawkular-btm.collector.batchthreads", null);
            if (pool != null) {
                this.executor = Executors.newFixedThreadPool(Integer.parseInt(pool));
            }
        }
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (BusinessTransactionReporter.this.businessTxns.size() > 0) {
                    try {
                        BusinessTransactionReporter.this.lock.lock();
                        BusinessTransactionReporter.this.submitBusinessTransactions();
                    }
                    finally {
                        BusinessTransactionReporter.this.lock.unlock();
                    }
                }
            }
        }, this.batchTime, this.batchTime, TimeUnit.MILLISECONDS);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void report(BusinessTransaction btxn) {
        if (this.businessTransactionPublisher != null) {
            try {
                this.lock.lock();
                this.businessTxns.add(btxn);
                if (this.businessTxns.size() < this.batchSize) return;
                this.submitBusinessTransactions();
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            log.warning("Business transaction service is not available!");
        }
    }

    protected void submitBusinessTransactions() {
        if (this.businessTxns.size() > 0) {
            final List<BusinessTransaction> toSend = this.businessTxns;
            this.businessTxns = new ArrayList<BusinessTransaction>();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BusinessTransactionReporter.this.businessTransactionPublisher.publish(BusinessTransactionReporter.this.tenantId, toSend);
                    }
                    catch (Exception e) {
                        log.log(Logger.Level.SEVERE, "Failed to publish business transactions", (Throwable)e);
                    }
                }
            });
        }
    }
}

