/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Component;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.NodeType;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.client.collector.internal.actions.ProcessorActionHandler;
import org.hawkular.btm.client.collector.internal.actions.ProcessorActionHandlerFactory;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class ProcessorManager {
    private static Logger log = Logger.getLogger((String)ProcessorManager.class.getName());
    private Map<String, List<ProcessorWrapper>> processors = new HashMap<String, List<ProcessorWrapper>>();

    public ProcessorManager(CollectorConfiguration config) {
        this.init(config);
    }

    protected void init(CollectorConfiguration config) {
        for (String btxn : config.getBusinessTransactions().keySet()) {
            BusinessTxnConfig btc = (BusinessTxnConfig)config.getBusinessTransactions().get(btxn);
            this.init(btxn, btc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String btxn, BusinessTxnConfig btc) {
        if (log.isLoggable(Logger.Level.FINE)) {
            log.fine("ProcessManager: initialise btxn '" + btxn + "' config=" + btc + " processors=" + btc.getProcessors().size());
        }
        if (btc.getProcessors() != null && !btc.getProcessors().isEmpty()) {
            ArrayList<ProcessorWrapper> procs = new ArrayList<ProcessorWrapper>();
            for (int i = 0; i < btc.getProcessors().size(); ++i) {
                procs.add(new ProcessorWrapper((Processor)btc.getProcessors().get(i)));
            }
            Map<String, List<ProcessorWrapper>> map = this.processors;
            synchronized (map) {
                this.processors.put(btxn, procs);
            }
        }
        Map<String, List<ProcessorWrapper>> map = this.processors;
        synchronized (map) {
            this.processors.remove(btxn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String btxn) {
        Map<String, List<ProcessorWrapper>> map = this.processors;
        synchronized (map) {
            this.processors.remove(btxn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessed(BusinessTransaction btxn, Node node, Direction direction) {
        boolean ret = false;
        if (btxn.getName() != null) {
            List<ProcessorWrapper> procs = null;
            Map<String, List<ProcessorWrapper>> map = this.processors;
            synchronized (map) {
                procs = this.processors.get(btxn.getName());
            }
            if (procs != null) {
                for (int i = 0; !ret && i < procs.size(); ++i) {
                    ret = procs.get(i).isProcessed(btxn, node, direction);
                }
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("ProcessManager: isProcessed btxn=" + btxn + " node=" + node + " direction=" + direction + "? " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContentProcessed(BusinessTransaction btxn, Node node, Direction direction) {
        boolean ret = false;
        if (btxn.getName() != null) {
            List<ProcessorWrapper> procs = null;
            Map<String, List<ProcessorWrapper>> map = this.processors;
            synchronized (map) {
                procs = this.processors.get(btxn.getName());
            }
            if (procs != null) {
                for (int i = 0; !ret && i < procs.size(); ++i) {
                    ret = procs.get(i).isProcessed(btxn, node, direction) && procs.get(i).usesContent();
                }
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("ProcessManager: isContentProcessed btxn=" + btxn + " node=" + node + " direction=" + direction + "? " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object ... values) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("ProcessManager: process btxn=" + btxn + " node=" + node + " direction=" + direction + " headers=" + headers + " values=" + values + " : available processors=" + this.processors);
        }
        if (btxn.getName() != null) {
            List<ProcessorWrapper> procs = null;
            Map<String, List<ProcessorWrapper>> map = this.processors;
            synchronized (map) {
                procs = this.processors.get(btxn.getName());
            }
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("ProcessManager: btxn name=" + btxn.getName() + " processors=" + procs);
            }
            if (procs != null) {
                for (int i = 0; i < procs.size(); ++i) {
                    procs.get(i).process(btxn, node, direction, headers, values);
                }
            }
        }
    }

    protected Map<String, List<ProcessorWrapper>> getProcessors() {
        return this.processors;
    }

    protected void setProcessors(Map<String, List<ProcessorWrapper>> processors) {
        this.processors = processors;
    }

    public class ProcessorActionWrapper {
        private ProcessorActionHandler handler;

        public ProcessorActionWrapper(ProcessorAction action) {
            this.handler = ProcessorActionHandlerFactory.getHandler(action);
            if (this.handler != null) {
                this.handler.init();
            }
        }

        public boolean isUsesHeaders() {
            return this.handler.isUsesHeaders();
        }

        public boolean isUsesContent() {
            return this.handler.isUsesContent();
        }

        public void process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("ProcessManager/Processor/Action[" + this.handler.getAction() + "]: process btxn=" + btxn + " node=" + node + " direction=" + direction + " headers=" + headers + " values=" + values);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        log.finest("        [value " + i + "] = " + values[i]);
                    }
                }
            }
            if (this.handler.isUsesHeaders() || this.handler.isUsesContent()) {
                if (this.handler.isUsesHeaders() && (headers == null || headers.isEmpty())) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("ProcessManager/Processor/Action[" + this.handler.getAction() + "]: uses headers but not supplied");
                    }
                    return;
                }
                if (this.handler.isUsesContent() && (values == null || values.length == 0)) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("ProcessManager/Processor/Action[" + this.handler.getAction() + "]: uses content values but not supplied");
                    }
                    return;
                }
            }
            this.handler.process(btxn, node, direction, headers, values);
        }
    }

    public class ProcessorWrapper {
        private Processor processor;
        private Predicate<String> uriFilter = null;
        private Predicate<String> faultFilter = null;
        private Object compiledPredicate = null;
        private List<ProcessorActionWrapper> actions = new ArrayList<ProcessorActionWrapper>();
        private boolean usesHeaders = false;
        private boolean usesContent = false;

        public ProcessorWrapper(Processor processor) {
            this.processor = processor;
            this.init();
        }

        protected void init() {
            if (this.processor.getUriFilter() != null) {
                this.uriFilter = Pattern.compile(this.processor.getUriFilter()).asPredicate();
            }
            if (this.processor.getFaultFilter() != null) {
                this.faultFilter = Pattern.compile(this.processor.getFaultFilter()).asPredicate();
            }
            try {
                ParserContext ctx = new ParserContext();
                ctx.addPackageImport("org.hawkular.btm.client.collector.internal.helpers");
                if (this.processor.getPredicate() != null) {
                    String text = this.processor.getPredicate().predicateText();
                    this.compiledPredicate = MVEL.compileExpression((String)text, (ParserContext)ctx);
                    if (this.compiledPredicate == null) {
                        log.severe("Failed to compile pr ocessorpredicate '" + text + "'");
                    } else if (log.isLoggable(Logger.Level.FINE)) {
                        log.fine("Initialised processor predicate '" + text + "' = " + this.compiledPredicate);
                    }
                    this.usesHeaders = text.indexOf("headers.") != -1;
                    this.usesContent = text.indexOf("values[") != -1;
                }
            }
            catch (Throwable t) {
                log.log(Logger.Level.SEVERE, "Failed to compile processor predicate '" + this.processor.getPredicate() + "'", t);
            }
            for (int i = 0; i < this.processor.getActions().size(); ++i) {
                ProcessorActionWrapper paw = new ProcessorActionWrapper((ProcessorAction)this.processor.getActions().get(i));
                if (!this.usesHeaders) {
                    this.usesHeaders = paw.isUsesHeaders();
                }
                if (!this.usesContent) {
                    this.usesContent = paw.isUsesContent();
                }
                this.actions.add(paw);
            }
        }

        protected Processor getProcessor() {
            return this.processor;
        }

        public boolean usesHeaders() {
            return this.usesHeaders;
        }

        public boolean usesContent() {
            return this.usesContent;
        }

        public boolean isProcessed(BusinessTransaction btxn, Node node, Direction direction) {
            boolean ret = false;
            if (this.processor.getNodeType() == node.getType() && this.processor.getDirection() == direction && (this.uriFilter == null || this.uriFilter.test(node.getUri()))) {
                ret = true;
            }
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("ProcessManager/Processor: isProcessed btxn=" + btxn + " node=" + node + " direction=" + direction + "? " + ret);
            }
            return ret;
        }

        public void process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
            int i;
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("ProcessManager/Processor: process btxn=" + btxn + " node=" + node + " direction=" + direction + " headers=" + headers + " values=" + values);
                if (values != null) {
                    for (i = 0; i < values.length; ++i) {
                        log.finest("        [value " + i + "] = " + values[i]);
                    }
                }
            }
            if (this.processor.getNodeType() == node.getType() && this.processor.getDirection() == direction) {
                if (this.uriFilter != null && !this.uriFilter.test(node.getUri())) {
                    return;
                }
                if (this.processor.getOperation() != null && node.getType() == NodeType.Component && !this.processor.getOperation().equals(((Component)node).getOperation())) {
                    return;
                }
                if (this.faultFilter == null && node.getFault() != null) {
                    return;
                }
                if (!(this.faultFilter == null || node.getFault() != null && this.faultFilter.test(node.getFault()))) {
                    return;
                }
                if (this.compiledPredicate != null) {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("btxn", btxn);
                    vars.put("node", node);
                    vars.put("headers", headers);
                    vars.put("values", values);
                    if (!((Boolean)MVEL.executeExpression((Object)this.compiledPredicate, vars)).booleanValue()) {
                        if (log.isLoggable(Logger.Level.FINEST)) {
                            log.finest("ProcessManager/Processor: process - predicate returned false");
                        }
                        return;
                    }
                }
                for (i = 0; i < this.actions.size(); ++i) {
                    this.actions.get(i).process(btxn, node, direction, headers, values);
                }
            }
        }

        public String toString() {
            return this.processor.toString();
        }
    }
}

