/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal.actions;

import java.util.HashMap;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.ExpressionBasedAction;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.client.collector.internal.actions.ProcessorActionHandler;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public abstract class ExpressionBasedActionHandler
extends ProcessorActionHandler {
    private static final Logger log = Logger.getLogger((String)ExpressionBasedActionHandler.class.getName());
    private Object compiledAction = null;

    public ExpressionBasedActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init() {
        super.init();
        if (((ExpressionBasedAction)this.getAction()).getExpression() != null) {
            try {
                ParserContext ctx = new ParserContext();
                ctx.addPackageImport("org.hawkular.btm.client.collector.internal.helpers");
                String text = ((ExpressionBasedAction)this.getAction()).getExpression().evaluateText();
                this.compiledAction = MVEL.compileExpression((String)text, (ParserContext)ctx);
                if (this.compiledAction == null) {
                    log.severe("Failed to compile action '" + text + "'");
                } else if (log.isLoggable(Logger.Level.FINE)) {
                    log.fine("Initialised processor action '" + text + "' = " + this.compiledAction);
                }
                if (!this.isUsesHeaders()) {
                    this.setUsesHeaders(text.indexOf("headers.") != -1);
                }
                if (!this.isUsesContent()) {
                    this.setUsesContent(text.indexOf("values[") != -1);
                }
            }
            catch (Throwable t) {
                log.log(Logger.Level.SEVERE, "Failed to compile expression for action '" + this.getAction() + "'", t);
            }
        } else {
            log.severe("No action expression defined for processor action=" + this.getAction());
        }
    }

    protected String getValue(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.compiledAction != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("btxn", btxn);
            vars.put("node", node);
            vars.put("headers", headers);
            vars.put("values", values);
            Object result = MVEL.executeExpression((Object)this.compiledAction, vars);
            if (result == null) {
                log.warning("Result for action '" + this.getAction() + "' was null");
            } else {
                String value = null;
                if (result.getClass() != String.class) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Converting result for action '" + this.getAction() + "' to a String, was: " + result.getClass());
                    }
                    value = result.toString();
                } else {
                    value = (String)result;
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("ProcessManager/Processor/Action: value=" + value);
                }
                return value;
            }
        }
        return null;
    }
}

