/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal.actions;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.config.btxn.AddContentAction;
import org.hawkular.btm.api.model.config.btxn.AddCorrelationIdAction;
import org.hawkular.btm.api.model.config.btxn.EvaluateURIAction;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.api.model.config.btxn.SetDetailAction;
import org.hawkular.btm.api.model.config.btxn.SetFaultAction;
import org.hawkular.btm.api.model.config.btxn.SetFaultDescriptionAction;
import org.hawkular.btm.api.model.config.btxn.SetPropertyAction;
import org.hawkular.btm.client.collector.internal.actions.AddContentActionHandler;
import org.hawkular.btm.client.collector.internal.actions.AddCorrelationIdActionHandler;
import org.hawkular.btm.client.collector.internal.actions.EvaluateURIActionHandler;
import org.hawkular.btm.client.collector.internal.actions.ProcessorActionHandler;
import org.hawkular.btm.client.collector.internal.actions.SetDetailActionHandler;
import org.hawkular.btm.client.collector.internal.actions.SetFaultActionHandler;
import org.hawkular.btm.client.collector.internal.actions.SetFaultDescriptionActionHandler;
import org.hawkular.btm.client.collector.internal.actions.SetPropertyActionHandler;

public class ProcessorActionHandlerFactory {
    private static final Logger log = Logger.getLogger((String)ProcessorActionHandlerFactory.class.getName());
    private static Map<Class<? extends ProcessorAction>, Class<? extends ProcessorActionHandler>> handlers = new HashMap<Class<? extends ProcessorAction>, Class<? extends ProcessorActionHandler>>();

    public static ProcessorActionHandler getHandler(ProcessorAction action) {
        ProcessorActionHandler ret = null;
        Class<? extends ProcessorActionHandler> cls = handlers.get(action.getClass());
        if (cls != null) {
            try {
                Constructor<? extends ProcessorActionHandler> con = cls.getConstructor(ProcessorAction.class);
                ret = con.newInstance(action);
            }
            catch (Exception e) {
                log.log(Logger.Level.SEVERE, "Failed to instantiate handler for action '" + action + "'", (Throwable)e);
            }
        }
        return ret;
    }

    static {
        handlers.put(AddContentAction.class, AddContentActionHandler.class);
        handlers.put(AddCorrelationIdAction.class, AddCorrelationIdActionHandler.class);
        handlers.put(EvaluateURIAction.class, EvaluateURIActionHandler.class);
        handlers.put(SetDetailAction.class, SetDetailActionHandler.class);
        handlers.put(SetFaultAction.class, SetFaultActionHandler.class);
        handlers.put(SetFaultDescriptionAction.class, SetFaultDescriptionActionHandler.class);
        handlers.put(SetPropertyAction.class, SetPropertyActionHandler.class);
    }
}

