/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal.helpers;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.hawkular.btm.api.logging.Logger;
import org.w3c.dom.Node;

public class XML {
    private static final Logger log = Logger.getLogger((String)XML.class.getName());
    private static final String DEFAULT_INDENT = "yes";
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String serialize(Object node) {
        String ret = null;
        if (node instanceof String) {
            ret = (String)node;
        } else if (node instanceof byte[]) {
            ret = new String((byte[])node);
        } else if (node instanceof DOMSource) {
            ret = XML.serializeDOMSource((DOMSource)node);
        } else if (node instanceof Node) {
            ret = XML.serializeNode((Node)node);
        } else {
            log.severe("Unable to serialize '" + node + "'");
        }
        if (ret != null) {
            ret = ret.trim();
        }
        return ret;
    }

    public static boolean predicate(String xpath, Object node) {
        Node domNode = XML.getNode(node);
        if (domNode == null) {
            log.severe("Unable to evaluate non DOM Node object");
            return false;
        }
        if (xpath == null) {
            log.severe("Predicate has not xpath expression");
            return false;
        }
        try {
            xpath = XML.getExpression(xpath);
            XPath xp = XPathFactory.newInstance().newXPath();
            Boolean result = (Boolean)xp.evaluate(xpath, domNode, XPathConstants.BOOLEAN);
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to execute predicate xpath '" + xpath + "'", (Throwable)e);
        }
        return false;
    }

    public static String evaluate(String xpath, Object node) {
        Node domNode = XML.getNode(node);
        if (domNode == null) {
            log.severe("Unable to evaluate non DOM Node object");
            return null;
        }
        if (xpath == null) {
            return XML.serialize(node);
        }
        try {
            xpath = XML.getExpression(xpath);
            XPath xp = XPathFactory.newInstance().newXPath();
            Node result = (Node)xp.evaluate(xpath, domNode, XPathConstants.NODE);
            if (result != null) {
                if (result.getNodeType() == 3) {
                    return result.getNodeValue();
                }
                return XML.serialize(result);
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to evaluate xpath '" + xpath + "'", (Throwable)e);
        }
        return null;
    }

    protected static String getExpression(String expr) {
        StringBuffer buf = new StringBuffer(expr);
        int startIndex = -1;
        do {
            if ((startIndex = buf.indexOf("*:")) == -1) continue;
            int endIndex = buf.indexOf("/", startIndex + 2);
            if (endIndex == -1) {
                endIndex = buf.length();
            }
            buf.replace(startIndex, endIndex, "*[local-name()='" + buf.substring(startIndex + 2, endIndex) + "']");
        } while (startIndex != -1);
        return buf.toString();
    }

    protected static String serializeNode(Node node) {
        return XML.serializeDOMSource(new DOMSource(node));
    }

    protected static String serializeDOMSource(DOMSource domSource) {
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
            transformer.setOutputProperty("indent", DEFAULT_INDENT);
            transformer.transform(domSource, result);
            writer.flush();
            return writer.toString();
        }
        catch (Throwable e) {
            log.log(Logger.Level.SEVERE, "Failed to serialize node", e);
            return null;
        }
    }

    protected static Node deserialize(Object node) {
        if (node instanceof Node) {
            return (Node)node;
        }
        if (node instanceof byte[]) {
            return XML.deserializeString(new String((byte[])node));
        }
        if (node instanceof String) {
            return XML.deserializeString((String)node);
        }
        log.severe("Unable to serialize '" + node + "'");
        return null;
    }

    protected static Node deserializeString(String doc) {
        try {
            StringReader reader = new StringReader(doc);
            StreamSource source = new StreamSource(reader);
            DOMResult result = new DOMResult();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
            transformer.setOutputProperty("indent", DEFAULT_INDENT);
            transformer.transform(source, result);
            return result.getNode();
        }
        catch (Throwable e) {
            log.log(Logger.Level.SEVERE, "Failed to serialize node", e);
            return null;
        }
    }

    protected static Node selectNode(String xpath, Object node) {
        Node domNode = XML.getNode(node);
        if (domNode == null) {
            log.severe("Unable to select node for non DOM Node object");
            return null;
        }
        try {
            xpath = XML.getExpression(xpath);
            XPath xp = XPathFactory.newInstance().newXPath();
            return (Node)xp.evaluate(xpath, domNode, XPathConstants.NODE);
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to select node for xpath '" + xpath + "'", (Throwable)e);
            return null;
        }
    }

    protected static Node getNode(Object node) {
        if (node instanceof Node) {
            return (Node)node;
        }
        if (node instanceof DOMSource) {
            return ((DOMSource)node).getNode();
        }
        Node n = XML.deserialize(node);
        if (n != null) {
            return n;
        }
        log.severe("Cannot convert '" + node + "' to DOM node");
        return null;
    }
}

