/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.btxn.service.inmemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.AbstractBusinessTransactionService;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.jboss.logging.Logger;

@Singleton
public class BusinessTransactionServiceInMemory
extends AbstractBusinessTransactionService {
    private static final String INMEM_MAXTXNS = "hawkular-btm.btxn-service.inmem-maxtxns";
    private final Logger log = Logger.getLogger(BusinessTransactionServiceInMemory.class);
    private static Map<String, BusinessTransaction> idMap = new HashMap<String, BusinessTransaction>();
    private static List<BusinessTransaction> txns = new ArrayList<BusinessTransaction>();
    private static int maxTransactions = 1000;

    public static List<BusinessTransaction> getTxns() {
        return txns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStore(String tenantId, BusinessTransaction btxn) throws Exception {
        List<BusinessTransaction> list = txns;
        synchronized (list) {
            BusinessTransaction old = idMap.put(btxn.getId(), btxn);
            if (old != null) {
                txns.remove(old);
            }
            txns.add(btxn);
            while (txns.size() > maxTransactions) {
                BusinessTransaction toRemove = txns.remove(0);
                idMap.remove(toRemove.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BusinessTransaction doGet(String tenantId, String id) {
        BusinessTransaction ret = null;
        List<BusinessTransaction> list = txns;
        synchronized (list) {
            ret = idMap.get(id);
        }
        this.log.tracef("Get business transaction with id[%s] is: %s", (Object)id, (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BusinessTransaction> doQuery(String tenantId, BusinessTransactionCriteria criteria) {
        ArrayList<BusinessTransaction> ret = new ArrayList<BusinessTransaction>();
        List<BusinessTransaction> list = txns;
        synchronized (list) {
            txns.stream().filter(p -> criteria.isValid(p)).forEach(p -> ret.add((BusinessTransaction)p));
        }
        this.log.tracef("Query business transactions with criteria[%s] is: %s", (Object)criteria, ret);
        return ret;
    }

    public static int getMaxTransactions() {
        return maxTransactions;
    }

    public static void setMaxTransactions(int maxTransactions) {
        BusinessTransactionServiceInMemory.maxTransactions = maxTransactions;
    }

    static {
        String prop = System.getProperty(INMEM_MAXTXNS);
        if (prop != null) {
            maxTransactions = Integer.parseInt(prop);
        }
    }
}

