/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.bus.inmemory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedExecutorService;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.trace.BusinessTransactionTrace;
import org.hawkular.btm.server.api.processors.BusinessTransactionBus;
import org.hawkular.btm.server.api.processors.BusinessTransactionFragmentHandler;
import org.hawkular.btm.server.api.processors.BusinessTransactionTraceHandler;
import org.jboss.logging.Logger;

public class BusinessTransactionBusInMemory
implements BusinessTransactionBus {
    private final Logger log = Logger.getLogger(BusinessTransactionBusInMemory.class);
    private List<BusinessTransactionFragmentHandler> fragmentHandlers = new ArrayList<BusinessTransactionFragmentHandler>();
    private List<BusinessTransactionTraceHandler> traceHandlers = new ArrayList<BusinessTransactionTraceHandler>();
    @Resource
    private ManagedExecutorService executorService;

    public List<BusinessTransactionFragmentHandler> getBusinessTransactionFragmentHandlers() {
        return this.fragmentHandlers;
    }

    public void setBusinessTransactionFragmentHandlers(List<BusinessTransactionFragmentHandler> fragmentHandlers) {
        this.fragmentHandlers = fragmentHandlers;
    }

    public List<BusinessTransactionTraceHandler> getTraceHandlers() {
        return this.traceHandlers;
    }

    public void setTraceHandlers(List<BusinessTransactionTraceHandler> traceHandlers) {
        this.traceHandlers = traceHandlers;
    }

    public void processFragments(String tenantId, List<BusinessTransaction> btxns) {
        if (this.fragmentHandlers.size() > 0) {
            this.log.tracef("Distribute business transaction fragments to " + this.fragmentHandlers.size() + " handlers: " + this.fragmentHandlers + " (with executor=" + this.executorService + ")", new Object[0]);
            for (int i = 0; i < this.fragmentHandlers.size(); ++i) {
                if (this.executorService == null) {
                    this.fragmentHandlers.get(i).handle(tenantId, btxns, null);
                    continue;
                }
                this.executorService.execute((Runnable)new BTxnFragmentHandlerTask(tenantId, this.fragmentHandlers.get(i), btxns));
            }
        }
    }

    public void processTraces(String tenantId, List<BusinessTransactionTrace> traces) {
        if (this.traceHandlers.size() > 0) {
            this.log.tracef("Distribute business transaction traces to " + this.traceHandlers.size() + " handlers: " + this.traceHandlers + " (with executor=" + this.executorService + ")", new Object[0]);
            for (int i = 0; i < this.traceHandlers.size(); ++i) {
                if (this.executorService == null) {
                    this.traceHandlers.get(i).handle(tenantId, traces, null);
                    continue;
                }
                this.executorService.execute((Runnable)new BTxnTraceHandlerTask(tenantId, this.traceHandlers.get(i), traces));
            }
        }
    }

    private static class BTxnTraceHandlerTask
    implements Runnable {
        private String tenantId;
        private BusinessTransactionTraceHandler handler;
        private List<BusinessTransactionTrace> traces;

        public BTxnTraceHandlerTask(String tenantId, BusinessTransactionTraceHandler handler, List<BusinessTransactionTrace> traces) {
            this.tenantId = tenantId;
            this.handler = handler;
            this.traces = traces;
        }

        @Override
        public void run() {
            this.handler.handle(this.tenantId, this.traces, null);
        }
    }

    private static class BTxnFragmentHandlerTask
    implements Runnable {
        private String tenantId;
        private BusinessTransactionFragmentHandler handler;
        private List<BusinessTransaction> businessTransactions;

        public BTxnFragmentHandlerTask(String tenantId, BusinessTransactionFragmentHandler handler, List<BusinessTransaction> btxns) {
            this.tenantId = tenantId;
            this.handler = handler;
            this.businessTransactions = btxns;
        }

        @Override
        public void run() {
            this.handler.handle(this.tenantId, this.businessTransactions, null);
        }
    }
}

