/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.inject.Inject;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.processors.BusinessTransactionFragmentHandler;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.jboss.logging.Logger;

public abstract class AbstractBusinessTransactionService
implements BusinessTransactionService {
    private final Logger log = Logger.getLogger(AbstractBusinessTransactionService.class);
    @Inject
    private List<BusinessTransactionFragmentHandler> handlers = new ArrayList<BusinessTransactionFragmentHandler>();
    @Resource
    private ManagedExecutorService executorService;

    public List<BusinessTransactionFragmentHandler> getBusinessTransactionFragmentHandlers() {
        return this.handlers;
    }

    public void setBusinessTransactionFragmentHandlers(List<BusinessTransactionFragmentHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void store(String tenantId, List<BusinessTransaction> btxns) throws Exception {
        int i;
        this.log.tracef("Store business transactions: %s", btxns);
        if (btxns.size() == 0) {
            return;
        }
        for (i = 0; i < btxns.size(); ++i) {
            this.doStore(tenantId, btxns.get(i));
        }
        if (this.handlers.size() > 0) {
            this.log.tracef("Distribute business transactions to " + this.handlers.size() + " handlers: " + this.handlers + " (with executor=" + this.executorService + ")", new Object[0]);
            for (i = 0; i < this.handlers.size(); ++i) {
                if (this.executorService == null) {
                    this.handlers.get(i).handle(tenantId, btxns);
                    continue;
                }
                this.executorService.execute((Runnable)new BTxnFragmentHandlerTask(tenantId, this.handlers.get(i), btxns));
            }
        }
    }

    protected abstract void doStore(String var1, BusinessTransaction var2) throws Exception;

    @Override
    public BusinessTransaction get(String tenantId, String id) {
        BusinessTransaction ret = this.doGet(tenantId, id);
        this.log.tracef("Get business transaction with id[%s] is: %s", (Object)id, (Object)ret);
        return ret;
    }

    protected abstract BusinessTransaction doGet(String var1, String var2);

    @Override
    public List<BusinessTransaction> query(String tenantId, BusinessTransactionCriteria criteria) {
        List<BusinessTransaction> ret = this.doQuery(tenantId, criteria);
        this.log.tracef("Query business transactions with criteria[%s] is: %s", (Object)criteria, ret);
        return ret;
    }

    protected abstract List<BusinessTransaction> doQuery(String var1, BusinessTransactionCriteria var2);

    private static class BTxnFragmentHandlerTask
    implements Runnable {
        private String tenantId;
        private BusinessTransactionFragmentHandler handler;
        private List<BusinessTransaction> businessTransactions;

        public BTxnFragmentHandlerTask(String tenantId, BusinessTransactionFragmentHandler handler, List<BusinessTransaction> btxns) {
            this.tenantId = tenantId;
            this.handler = handler;
            this.businessTransactions = btxns;
        }

        @Override
        public void run() {
            this.handler.handle(this.tenantId, this.businessTransactions);
        }
    }
}

