/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import org.hawkular.btm.api.client.BusinessTransactionCollector;
import org.hawkular.btm.api.client.Logger;
import org.hawkular.btm.api.client.SessionManager;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Component;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Message;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.btxn.Service;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.api.util.ServiceResolver;
import org.hawkular.btm.client.collector.internal.FragmentBuilder;
import org.hawkular.btm.client.collector.internal.FragmentManager;

public class DefaultBusinessTransactionCollector
implements BusinessTransactionCollector,
SessionManager {
    private static final Logger log = Logger.getLogger(DefaultBusinessTransactionCollector.class.getName());
    private FragmentManager fragmentManager = new FragmentManager();
    private String tenantId = System.getProperty("hawkular-btm.tenantId");
    private BusinessTransactionService businessTransactionService;
    private Map<String, FragmentBuilder> links = new ConcurrentHashMap<String, FragmentBuilder>();
    private static final Logger.Level warningLogLevel = Logger.Level.WARNING;

    public DefaultBusinessTransactionCollector() {
        CompletableFuture<BusinessTransactionService> bts = ServiceResolver.getSingletonService(BusinessTransactionService.class);
        bts.whenCompleteAsync((BiConsumer)new BiConsumer<BusinessTransactionService, Throwable>(){

            @Override
            public void accept(BusinessTransactionService arg0, Throwable arg1) {
                if (DefaultBusinessTransactionCollector.this.businessTransactionService == null) {
                    DefaultBusinessTransactionCollector.this.setBusinessTransactionService(arg0);
                    if (arg1 != null) {
                        log.severe("Failed to locate Business Transaction Service: " + arg1);
                    } else {
                        log.info("Initialised Business Transaction Service: " + arg0 + " in this=" + this);
                    }
                }
            }
        });
    }

    @Override
    public void consumerStart(String uri, String type, String id, Map<String, ?> headers, Object ... values) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Consumer start: type=" + type + " uri=" + uri + " id=" + id + " headers=" + headers + " values=" + values);
            }
            try {
                Consumer consumer = new Consumer();
                consumer.setEndpointType(type);
                consumer.setUri(uri);
                this.processValues(consumer, true, id, headers, values);
                this.push(consumer);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "consumerStart failed", t);
            }
        }
    }

    @Override
    public void consumerEnd(String uri, String type, String id, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Consumer end: type=" + type + " uri=" + uri + " id=" + id + " headers=" + headers + " values=" + values);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Consumer consumer = this.pop(builder, Consumer.class);
                    this.processValues(consumer, false, id, headers, values);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "consumerEnd failed", t);
            }
        }
    }

    @Override
    public void serviceStart(String uri, String operation, Map<String, ?> headers, Object ... values) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Service start: uri=" + uri + " operation=" + operation + " values=" + values);
            }
            try {
                Service service = new Service();
                service.setUri(uri);
                service.setOperation(operation);
                this.processValues(service, true, null, headers, values);
                this.push(service);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "serviceStart failed", t);
            }
        }
    }

    @Override
    public void serviceEnd(String uri, String operation, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Service end: uri=" + uri + " operation=" + operation + " values=" + values);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Service service = this.pop(builder, Service.class);
                    this.processValues(service, false, null, headers, values);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "serviceEnd failed", t);
            }
        }
    }

    @Override
    public void componentStart(String uri, String type, String operation) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Component start: type=" + type + " operation=" + operation + " uri=" + uri);
            }
            try {
                Component component = new Component();
                component.setComponentType(type);
                component.setUri(uri);
                component.setOperation(operation);
                this.push(component);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "componentStart failed", t);
            }
        }
    }

    @Override
    public void componentEnd(String uri, String type, String operation) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Component end: type=" + type + " operation=" + operation + " uri=" + uri);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    this.pop(builder, Component.class);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "componentEnd failed", t);
            }
        }
    }

    @Override
    public void producerStart(String uri, String type, String id, Map<String, ?> headers, Object ... values) {
        block3: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Producer start: type=" + type + " uri=" + uri + " id=" + id + " headers=" + headers + " values=" + values);
            }
            try {
                Producer producer = new Producer();
                producer.setEndpointType(type);
                producer.setUri(uri);
                this.processValues(producer, true, id, headers, values);
                this.push(producer);
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block3;
                log.log(warningLogLevel, "producerStart failed", t);
            }
        }
    }

    @Override
    public void producerEnd(String uri, String type, String id, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Producer end: type=" + type + " uri=" + uri + " id=" + id + " headers=" + headers + " values=" + values);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Producer producer = this.pop(builder, Producer.class);
                    this.processValues(producer, false, id, headers, values);
                    this.checkForCompletion(builder);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "producerEnd failed", t);
            }
        }
    }

    @Override
    public void setProperty(String name, String value) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Add property: name=" + name + " value=" + value);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getBusinessTransaction().getProperties().put(name, value);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "setProperty failed", t);
            }
        }
    }

    @Override
    public void setDetail(String name, String value) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Add property: name=" + name + " value=" + value);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getCurrentNode().getDetails().put(name, value);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "setDetail failed", t);
            }
        }
    }

    public BusinessTransactionService getBusinessTransactionService() {
        return this.businessTransactionService;
    }

    public void setBusinessTransactionService(BusinessTransactionService businessTransactionService) {
        this.businessTransactionService = businessTransactionService;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    protected void push(Node node) {
        FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
        if (builder != null) {
            node.setStartTime(System.currentTimeMillis());
            builder.pushNode(node);
        }
    }

    protected <T extends Node> T pop(FragmentBuilder builder, Class<T> cls) {
        if (builder == null) {
            if (log.isLoggable(Logger.Level.WARNING)) {
                log.warning("No fragment builder for this thread (" + Thread.currentThread() + ") - trying to pop node of type: " + cls);
            }
            return null;
        }
        if (builder.getCurrentNode() == null) {
            if (log.isLoggable(Logger.Level.WARNING)) {
                log.warning("No 'current node' for this thread (" + Thread.currentThread() + ") - trying to pop node of type: " + cls);
            }
            return null;
        }
        if (builder.getCurrentNode().getClass() == cls) {
            Node node = builder.popNode();
            node.setDuration(System.currentTimeMillis() - node.getStartTime());
            return (T)((Node)cls.cast(node));
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Current node (type=" + builder.getCurrentNode().getClass() + ") does not match required cls=" + cls);
        }
        return null;
    }

    protected void processValues(InteractionNode node, boolean req, String id, Map<String, ?> headers, Object[] values) {
        Message m = new Message();
        m.setId(id);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                m.getParameters().add(values[i].toString());
            }
        }
        if (id != null && req) {
            node.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                Object value = headers.get(key);
                if (value.getClass() != String.class) continue;
                m.getHeaders().put(key, (String)value);
            }
        }
        if (req) {
            node.setRequest(m);
        } else {
            node.setResponse(m);
        }
    }

    protected void checkForCompletion(FragmentBuilder builder) {
        if (builder.isComplete()) {
            final BusinessTransaction btxn = builder.getBusinessTransaction();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Record business transaction: " + btxn);
            }
            if (this.businessTransactionService != null) {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<BusinessTransaction> btxns = new ArrayList<BusinessTransaction>();
                        btxns.add(btxn);
                        try {
                            DefaultBusinessTransactionCollector.this.businessTransactionService.store(DefaultBusinessTransactionCollector.this.tenantId, btxns);
                        }
                        catch (Exception e) {
                            log.log(Logger.Level.SEVERE, "Failed to store business transactions", e);
                        }
                    }
                });
            } else {
                log.warning("Business transaction service is not available!");
            }
            this.fragmentManager.clear();
        }
    }

    @Override
    public boolean isActive() {
        try {
            return this.fragmentManager.hasFragmentBuilder();
        }
        catch (Throwable t) {
            if (log.isLoggable(warningLogLevel)) {
                log.log(warningLogLevel, "isActive failed", t);
            }
            return false;
        }
    }

    @Override
    public void retainNode(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Retain node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.retainNode(id);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "retainNode failed", t);
            }
        }
    }

    @Override
    public void releaseNode(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Release node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.releaseNode(id);
                    this.checkForCompletion(builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "releaseNode failed", t);
            }
        }
    }

    @Override
    public Node retrieveNode(String id) {
        Node ret;
        block4: {
            ret = null;
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Retrieve node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    ret = builder.retrieveNode(id);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "retrieveNode failed", t);
            }
        }
        return ret;
    }

    @Override
    public void initiateLink(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Initiate link: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getUnlinkedIds().add(id);
                    this.links.put(id, builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "initiateLink failed", t);
            }
        }
    }

    @Override
    public void completeLink(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Complete link: id=" + id);
            }
            try {
                FragmentBuilder builder = this.links.get(id);
                if (builder != null) {
                    builder.getUnlinkedIds().remove(id);
                    this.links.remove(id);
                    this.fragmentManager.setFragmentBuilder(builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "completeLink failed", t);
            }
        }
    }

    @Override
    public void unlink() {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Unlink");
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    this.fragmentManager.clear();
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "unlink failed", t);
            }
        }
    }

    @Override
    public void assertComplete() {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Assert complete");
            }
            try {
                FragmentBuilder builder;
                if (this.fragmentManager.hasFragmentBuilder() && !(builder = this.fragmentManager.getFragmentBuilder()).isComplete()) {
                    log.severe("Business transaction has not completed: " + this.fragmentManager.getFragmentBuilder());
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "assertComplete failed", t);
            }
        }
    }

    @Override
    public SessionManager session() {
        return this;
    }

    protected FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }
}

