/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.btxn.service.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.client.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.BusinessTransactionService;

public class BusinessTransactionServiceRESTClient
implements BusinessTransactionService {
    private static final Logger log = Logger.getLogger(BusinessTransactionServiceRESTClient.class.getName());
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String HAWKULAR_PERSONA = "Hawkular-Persona";
    private String username = System.getProperty("hawkular-btm.username");
    private String password = System.getProperty("hawkular-btm.password");
    private String authorization = null;
    private String baseUrl = System.getProperty("hawkular-btm.base-uri");

    public BusinessTransactionServiceRESTClient() {
        if (this.baseUrl != null && this.baseUrl.length() > 0 && this.baseUrl.charAt(this.baseUrl.length() - 1) != '/') {
            this.baseUrl = this.baseUrl + '/';
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void store(String tenantId, List<BusinessTransaction> btxns) throws Exception {
        URL url = new URL(this.baseUrl + "transactions");
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Store btxns [tenant=" + tenantId + "][url=" + url + "]: " + btxns);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        this.addHeaders(connection, tenantId);
        OutputStream os = connection.getOutputStream();
        os.write(mapper.writeValueAsBytes(btxns));
        os.flush();
        os.close();
        int statusCode = connection.getResponseCode();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Status code is: " + statusCode);
        }
        if (statusCode != 200) {
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Failed to store business transactions: status=[" + statusCode + "]");
            }
            throw new Exception(connection.getResponseMessage());
        }
    }

    @Override
    public BusinessTransaction get(String tenantId, String id) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction: tenantId=[" + tenantId + "] id=[" + id + "]");
        }
        try {
            URL url = new URL(this.baseUrl + "transactions/" + id);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + new String(b) + "]");
                }
                try {
                    return mapper.readValue(b, BusinessTransaction.class);
                }
                catch (Throwable t) {
                    log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'get' business transaction request", e);
        }
        return null;
    }

    @Override
    public List<BusinessTransaction> query(String tenantId, BusinessTransactionCriteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transactions: tenantId=[" + tenantId + "] query=[" + criteria + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("transactions");
        Map<String, String> queryParams = BusinessTransactionServiceRESTClient.getQueryParameters(criteria);
        if (!queryParams.isEmpty()) {
            builder.append('?');
            for (String key : queryParams.keySet()) {
                if (builder.length() > 0) {
                    builder.append('&');
                }
                String value = queryParams.get(key);
                builder.append(key);
                builder.append('=');
                builder.append(value);
            }
        }
        try {
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + new String(b) + "]");
                }
                try {
                    return (List)mapper.readValue(b, BUSINESS_TXN_LIST);
                }
                catch (Throwable t) {
                    log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to query business transaction: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'query' business transaction request", e);
        }
        return null;
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_PERSONA, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }

    protected static Map<String, String> getQueryParameters(BusinessTransactionCriteria criteria) {
        StringBuilder buf;
        boolean first;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (criteria.getStartTime() > 0L) {
            ret.put("startTime", "" + criteria.getStartTime());
        }
        if (criteria.getEndTime() > 0L) {
            ret.put("endTime", "" + criteria.getEndTime());
        }
        if (!criteria.getProperties().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (String key : criteria.getProperties().keySet()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(key);
                buf.append('|');
                buf.append(criteria.getProperties().get(key));
            }
            ret.put("properties", buf.toString());
        }
        if (!criteria.getCorrelationIds().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (CorrelationIdentifier cid : criteria.getCorrelationIds()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(cid.getScope().name());
                buf.append('|');
                buf.append(cid.getValue());
            }
            ret.put("correlations", buf.toString());
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Criteria [" + criteria + "] query parameters [" + ret + "]");
        }
        return ret;
    }
}

