/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.ArrayList;
import java.util.List;
import org.hawkular.btm.api.model.admin.BusinessTxnConfig;
import org.hawkular.btm.api.model.admin.CollectorConfiguration;
import org.hawkular.btm.client.collector.internal.FilterProcessor;

public class FilterManager {
    private List<FilterProcessor> globalExclusionFilters = new ArrayList<FilterProcessor>();
    private List<FilterProcessor> btxnFilters = new ArrayList<FilterProcessor>();
    private boolean onlyNamedTransactions = false;

    public FilterManager(CollectorConfiguration config) {
        this.init(config);
    }

    protected void init(CollectorConfiguration config) {
        for (String btxn : config.getBusinessTransactions().keySet()) {
            BusinessTxnConfig btc;
            FilterProcessor fp = new FilterProcessor(btxn, (btc = config.getBusinessTransactions().get(btxn)).getFilter());
            if (fp.isIncludeAll()) {
                this.globalExclusionFilters.add(fp);
                continue;
            }
            this.btxnFilters.add(fp);
        }
        this.onlyNamedTransactions = new Boolean(config.getProperty("hawkular-btm.collector.onlynamed", Boolean.FALSE.toString()));
    }

    public String getBusinessTransactionName(String uri) {
        int i;
        String ret = this.onlyNamedTransactions ? null : "";
        for (i = 0; i < this.globalExclusionFilters.size(); ++i) {
            if (!this.globalExclusionFilters.get(i).isExcluded(uri)) continue;
            return null;
        }
        for (i = 0; i < this.btxnFilters.size(); ++i) {
            if (!this.btxnFilters.get(i).isIncluded(uri)) continue;
            if (this.btxnFilters.get(i).isExcluded(uri)) {
                return null;
            }
            ret = this.btxnFilters.get(i).getBusinessTransaction();
            break;
        }
        return ret;
    }
}

