/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.Node;

public class FragmentBuilder {
    private static final Logger log = Logger.getLogger(FragmentBuilder.class.getName());
    private BusinessTransaction businessTransaction;
    private Stack<Node> nodeStack = new Stack();
    private Stack<Node> poppedNodes = new Stack();
    private Stack<Node> suppressedNodeStack = new Stack();
    private Map<String, Node> retainedNodes = new HashMap<String, Node>();
    private List<String> uncompletedCorrelationIds = new ArrayList<String>();
    private boolean suppress = false;
    private static String hostName;
    private static String hostAddress;
    private int inHashCode = 0;
    private ByteArrayOutputStream inStream = null;
    private int outHashCode = 0;
    private ByteArrayOutputStream outStream = null;

    public FragmentBuilder() {
        this.businessTransaction = new BusinessTransaction().setId(UUID.randomUUID().toString()).setStartTime(System.currentTimeMillis()).setHostName(hostName).setHostAddress(hostAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            return this.nodeStack.isEmpty() && this.retainedNodes.isEmpty();
        }
    }

    public BusinessTransaction getBusinessTransaction() {
        return this.businessTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getCurrentNode() {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            return this.nodeStack.isEmpty() ? null : this.nodeStack.peek();
        }
    }

    public Stack<Node> getNodeStack() {
        return this.nodeStack;
    }

    public Stack<Node> getPoppedNodes() {
        return this.poppedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushNode(Node node) {
        this.inStream = null;
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            this.poppedNodes.clear();
            if (this.suppress) {
                this.suppressedNodeStack.push(node);
                return;
            }
            if (this.nodeStack.isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Pushing top level node: " + node + " for txn: " + this.businessTransaction);
                }
                this.businessTransaction.getNodes().add(node);
            } else {
                Node parent = this.nodeStack.peek();
                if (parent instanceof ContainerNode) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Add node: " + node + " to parent: " + parent + " in txn: " + this.businessTransaction);
                    }
                    ((ContainerNode)parent).getNodes().add(node);
                } else {
                    log.severe("Attempt to add node '" + node + "' under non-container node '" + parent + "'");
                }
            }
            this.nodeStack.push(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node popNode(Class<? extends Node> cls, String uri) {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            if (this.suppress) {
                if (!this.suppressedNodeStack.isEmpty()) {
                    Node suppressed = this.popNode(this.suppressedNodeStack, cls, uri);
                    if (suppressed != null) {
                        return suppressed;
                    }
                } else {
                    this.suppress = false;
                }
            }
            return this.popNode(this.nodeStack, cls, uri);
        }
    }

    protected Node popNode(Stack<Node> stack, Class<? extends Node> cls, String uri) {
        Node top;
        Node node = top = stack.isEmpty() ? null : stack.peek();
        if (top != null) {
            if (this.nodeMatches(top, cls, uri)) {
                Node node2 = stack.pop();
                this.poppedNodes.push(node2);
                return node2;
            }
            for (int i = stack.size() - 2; i >= 0; --i) {
                if (!this.nodeMatches((Node)stack.get(i), cls, uri)) continue;
                Node node3 = (Node)stack.remove(i);
                this.poppedNodes.push(node3);
                return node3;
            }
        }
        return null;
    }

    protected boolean nodeMatches(Node node, Class<? extends Node> cls, String uri) {
        if (node.getClass() == cls) {
            return uri == null || uri.equals(node.getUri());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            Node current = this.getCurrentNode();
            if (current != null) {
                this.retainedNodes.put(id, current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node releaseNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            return this.retainedNodes.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node retrieveNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            return this.retainedNodes.get(id);
        }
    }

    public List<String> getUncompletedCorrelationIds() {
        return this.uncompletedCorrelationIds;
    }

    public void suppress() {
        this.suppress = true;
    }

    public boolean isSuppressed() {
        return this.suppress;
    }

    public void initInBuffer(int hashCode) {
        this.inHashCode = hashCode;
        this.inStream = new ByteArrayOutputStream();
    }

    public boolean isInBufferActive(int hashCode) {
        return this.inStream != null && (hashCode == -1 || hashCode == this.inHashCode);
    }

    public void writeInData(int hashCode, byte[] b, int offset, int len) {
        if (this.inStream != null && (hashCode == -1 || hashCode == this.inHashCode)) {
            this.inStream.write(b, offset, len);
        }
    }

    public byte[] getInData(int hashCode) {
        if (this.inStream != null && (hashCode == -1 || hashCode == this.inHashCode)) {
            try {
                this.inStream.close();
            }
            catch (IOException e) {
                log.severe("Failed to close in data stream: " + e);
            }
            byte[] b = this.inStream.toByteArray();
            this.inStream = null;
            return b;
        }
        return null;
    }

    public void initOutBuffer(int hashCode) {
        this.outHashCode = hashCode;
        this.outStream = new ByteArrayOutputStream();
    }

    public boolean isOutBufferActive(int hashCode) {
        return this.outStream != null && (hashCode == -1 || hashCode == this.outHashCode);
    }

    public void writeOutData(int hashCode, byte[] b, int offset, int len) {
        if (this.outStream != null && (hashCode == -1 || hashCode == this.outHashCode)) {
            this.outStream.write(b, offset, len);
        }
    }

    public byte[] getOutData(int hashCode) {
        if (this.outStream != null && (hashCode == -1 || hashCode == this.outHashCode)) {
            try {
                this.outStream.close();
            }
            catch (IOException e) {
                log.severe("Failed to close out data stream: " + e);
            }
            byte[] b = this.outStream.toByteArray();
            this.outStream = null;
            return b;
        }
        return null;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("Fragment builder: current btxn=[");
        info.append(this.businessTransaction);
        info.append("] complete=");
        info.append(this.isComplete());
        info.append(" unlinkedIds=");
        info.append(this.getUncompletedCorrelationIds());
        info.append(" stack=\r\n");
        for (Node node : this.nodeStack) {
            info.append("         node: ");
            info.append(node);
            info.append("\r\n");
        }
        return info.toString();
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.severe("Unable to determine host name");
        }
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.severe("Unable to determine host address");
        }
    }
}

