/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.btxn;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;

public class BusinessTransaction {
    @JsonInclude
    private String id;
    @JsonInclude
    private long startTime;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String hostName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String hostAddress;
    @JsonInclude
    private List<Node> nodes = new ArrayList<Node>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> properties = new HashMap<String, String>();

    public String getId() {
        return this.id;
    }

    public BusinessTransaction setId(String id) {
        this.id = id;
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public BusinessTransaction setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BusinessTransaction setName(String name) {
        this.name = name;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public BusinessTransaction setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public BusinessTransaction setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public BusinessTransaction setNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public BusinessTransaction setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public long endTime() {
        if (this.startTime > 0L && !this.nodes.isEmpty()) {
            long endTimeNS = 0L;
            for (int i = 0; i < this.getNodes().size(); ++i) {
                Node node = this.getNodes().get(i);
                long et = node.overallEndTime();
                if (et <= endTimeNS) continue;
                endTimeNS = et;
            }
            long elapsedTime = endTimeNS - this.getNodes().get(0).getBaseTime();
            return this.getStartTime() + TimeUnit.MILLISECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS);
        }
        return 0L;
    }

    public Set<Node> getCorrelatedNodes(CorrelationIdentifier cid) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.getNodes()) {
            n.findCorrelatedNodes(cid, ret);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostAddress == null ? 0 : this.hostAddress.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusinessTransaction other = (BusinessTransaction)obj;
        if (this.hostAddress == null ? other.hostAddress != null : !this.hostAddress.equals(other.hostAddress)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "BusinessTransaction [id=" + this.id + ", name=" + this.name + ", hostName=" + this.hostName + ", hostAddress=" + this.hostAddress + ", nodes=" + this.nodes + ", properties=" + this.properties + "]";
    }
}

