/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.manager.headers;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.client.api.HeadersAccessor;

public class JbossSwitchyardHeadersAccessor
implements HeadersAccessor {
    private static final Logger log = Logger.getLogger(JbossSwitchyardHeadersAccessor.class.getName());
    private static final String TARGET_TYPE = "org.switchyard.Context";
    private static final String PROPERTY_CLASS = "org.switchyard.Property";

    @Override
    public String getTargetType() {
        return TARGET_TYPE;
    }

    @Override
    public Map<String, String> getHeaders(Object target) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(TARGET_TYPE);
            Class<?> propertyClass = Thread.currentThread().getContextClassLoader().loadClass(PROPERTY_CLASS);
            Method getPropertiesMethod = cls.getMethod("getProperties", new Class[0]);
            Method nameMethod = propertyClass.getMethod("getName", new Class[0]);
            Method valueMethod = propertyClass.getMethod("getValue", new Class[0]);
            Set properties = (Set)getPropertiesMethod.invoke(target, new Object[0]);
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Object prop : properties) {
                String name = (String)nameMethod.invoke(prop, new Object[0]);
                Object value = valueMethod.invoke(prop, new Object[0]);
                if (!(value instanceof String)) continue;
                headers.put(name, (String)value);
            }
            return headers;
        }
        catch (Throwable t) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.log(Logger.Level.FINEST, "Failed to obtain headers", t);
            }
            return null;
        }
    }
}

