/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.check;

import org.jboss.byteman.check.RuleCheck;
import org.jboss.byteman.check.RuleCheckResult;

public class TestScript {
    public static void main(String[] args) {
        int length = args.length;
        RuleCheck check = new RuleCheck();
        check.setPrintStream(System.out);
        int start = 0;
        boolean verbose = false;
        while (start < length) {
            if (args[start].equals("-p")) {
                if (++start == length) {
                    TestScript.usage();
                    return;
                }
                String packageName = args[start++];
                check.addPackage(packageName);
                continue;
            }
            if (args[start].equals("-v")) {
                ++start;
                verbose = true;
                continue;
            }
            if (!args[start].equals("-h")) break;
            TestScript.usage();
            return;
        }
        if (start == length) {
            TestScript.usage();
            return;
        }
        while (start < length) {
            check.addRuleFile(args[start++]);
        }
        check.checkRules();
        RuleCheckResult result = check.getResult();
        if (result.hasError()) {
            int parseErrorCount = result.getParseErrorCount();
            int typeErrorCount = result.getTypeErrorCount();
            int typeWarningCount = result.getTypeWarningCount();
            int warningCount = result.getWarningCount() + typeWarningCount;
            int errorCount = result.getErrorCount() + parseErrorCount + typeErrorCount + typeWarningCount;
            System.out.println("TestScript: " + errorCount + " total errors");
            System.err.println("            " + warningCount + " total warnings");
            System.err.println("            " + parseErrorCount + " parse errors");
            System.err.println("            " + typeErrorCount + " type errors");
            System.err.println("            " + typeWarningCount + " type warnings");
        } else if (result.hasWarning()) {
            int typeWarningCount = result.getTypeWarningCount();
            int warningCount = result.getWarningCount() + typeWarningCount;
            System.out.println("TestScript: " + warningCount + " total warnings");
            System.err.println("            " + typeWarningCount + " type warnings");
        } else {
            System.err.println("TestScript: no errors");
        }
    }

    public static void usage() {
        System.out.println("usage : java org.jboss.byteman.TestScript [-p <package>]* [-v] scriptfile1 ...");
        System.out.println("        -p specify package to lookup non-package qualified classnames");
        System.out.println("        -v display parsed rules");
        System.out.println("        n.b. place the byteman jar and classes mentioned in the ");
        System.out.println("        scripts in the classpath");
    }
}

