/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.compiler;

import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;

public class CompileContext {
    private int sourceLine = -1;
    private int stackCount = 0;
    private int stackMax = 0;
    private int localCount = 0;
    private int localMax = 0;
    private MethodVisitor mv;

    CompileContext(MethodVisitor mv) {
        this.mv = mv;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public int getLocalCount() {
        return this.localCount;
    }

    public int getStackMax() {
        return this.stackMax;
    }

    public int getLocalMax() {
        return this.localMax;
    }

    public void addStackCount(int count) {
        this.stackCount += count;
        if (this.stackCount > this.stackMax) {
            this.stackMax = this.stackCount;
        }
    }

    public void addLocalCount(int count) {
        this.localCount += count;
        if (this.localCount > this.localMax) {
            this.localMax = this.localCount;
        }
    }

    public void notifySourceLine(int line) {
        if (line > this.sourceLine) {
            this.sourceLine = line;
            Label label = new Label();
            this.mv.visitLabel(label);
            this.mv.visitLineNumber(this.sourceLine, label);
        }
    }

    public void notifySourceEnd() {
        Label label = new Label();
        this.mv.visitLabel(label);
        this.mv.visitLineNumber(this.sourceLine + 1, label);
    }
}

