/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.token;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.token.EvaluationContextImpl;
import com.jayway.jsonpath.internal.token.PathToken;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayPathToken
extends PathToken {
    private static final Logger logger = LoggerFactory.getLogger(ArrayPathToken.class);
    private final List<Integer> criteria;
    private final Operation operation;
    private final boolean isDefinite;

    public ArrayPathToken(List<Integer> criteria, Operation operation) {
        this.criteria = criteria;
        this.operation = operation;
        this.isDefinite = Operation.SINGLE_INDEX == operation || Operation.CONTEXT_SIZE == operation;
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (model == null) {
            throw new PathNotFoundException("The path " + currentPath + " is null");
        }
        if (!ctx.jsonProvider().isArray(model)) {
            throw new InvalidPathException(String.format("Filter: %s can only be applied to arrays. Current context is: %s", this.toString(), model));
        }
        try {
            switch (this.operation) {
                case SINGLE_INDEX: {
                    this.handleArrayIndex(this.criteria.get(0), currentPath, model, ctx);
                    break;
                }
                case INDEX_SEQUENCE: {
                    for (Integer i : this.criteria) {
                        this.handleArrayIndex(i, currentPath, model, ctx);
                    }
                    break;
                }
                case CONTEXT_SIZE: {
                    int length = ctx.jsonProvider().length(model);
                    int idx = length + this.criteria.get(0);
                    this.handleArrayIndex(idx, currentPath, model, ctx);
                    break;
                }
                case SLICE_FROM: {
                    int input = this.criteria.get(0);
                    int length = ctx.jsonProvider().length(model);
                    int from = input;
                    if (from < 0) {
                        from = length + from;
                    }
                    from = Math.max(0, from);
                    logger.debug("Slice from index on array with length: {}. From index: {} to: {}. Input: {}", length, from, length - 1, this.toString());
                    if (length == 0 || from >= length) {
                        return;
                    }
                    for (int i = from; i < length; ++i) {
                        this.handleArrayIndex(i, currentPath, model, ctx);
                    }
                    break;
                }
                case SLICE_TO: {
                    int input = this.criteria.get(0);
                    int length = ctx.jsonProvider().length(model);
                    int to = input;
                    if (to < 0) {
                        to = length + to;
                    }
                    to = Math.min(length, to);
                    logger.debug("Slice to index on array with length: {}. From index: 0 to: {}. Input: {}", length, to, this.toString());
                    if (length == 0) {
                        return;
                    }
                    for (int i = 0; i < to; ++i) {
                        this.handleArrayIndex(i, currentPath, model, ctx);
                    }
                    break;
                }
                case SLICE_BETWEEN: {
                    int from = this.criteria.get(0);
                    int to = this.criteria.get(1);
                    int length = ctx.jsonProvider().length(model);
                    to = Math.min(length, to);
                    if (from >= to || length == 0) {
                        return;
                    }
                    logger.debug("Slice between indexes on array with length: {}. From index: {} to: {}. Input: {}", length, from, to, this.toString());
                    for (int i = from; i < to; ++i) {
                        this.handleArrayIndex(i, currentPath, model, ctx);
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new PathNotFoundException("Index out of bounds when evaluating path " + currentPath);
        }
    }

    @Override
    public String getPathFragment() {
        StringBuilder sb = new StringBuilder();
        if (Operation.SINGLE_INDEX == this.operation || Operation.INDEX_SEQUENCE == this.operation) {
            sb.append("[").append(Utils.join(",", "", this.criteria)).append("]");
        } else if (Operation.CONTEXT_SIZE == this.operation) {
            sb.append("[@.size()").append(this.criteria.get(0)).append("]");
        } else if (Operation.SLICE_FROM == this.operation) {
            sb.append("[").append(this.criteria.get(0)).append(":]");
        } else if (Operation.SLICE_TO == this.operation) {
            sb.append("[:").append(this.criteria.get(0)).append("]");
        } else if (Operation.SLICE_BETWEEN == this.operation) {
            sb.append("[").append(this.criteria.get(0)).append(":").append(this.criteria.get(1)).append("]");
        } else {
            sb.append("NOT IMPLEMENTED");
        }
        return sb.toString();
    }

    @Override
    boolean isTokenDefinite() {
        return this.isDefinite;
    }

    public static enum Operation {
        CONTEXT_SIZE,
        SLICE_TO,
        SLICE_FROM,
        SLICE_BETWEEN,
        INDEX_SEQUENCE,
        SINGLE_INDEX;

    }
}

