/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.inventory;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.processors.BusinessTransactionFragmentHandler;
import org.hawkular.btm.processor.inventory.InventoryService;
import org.hawkular.btm.processor.inventory.log.MsgLogger;
import org.jboss.logging.Logger;

public class InventoryEnricher
implements BusinessTransactionFragmentHandler {
    private final Logger log = Logger.getLogger(InventoryEnricher.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    @Inject
    private Instance<InventoryService> injectedInventoryService;
    private InventoryService inventoryService;

    @PostConstruct
    public void init() {
        if (this.injectedInventoryService.isUnsatisfied()) {
            this.msgLog.warnNoInventoryService();
        } else {
            this.inventoryService = (InventoryService)this.injectedInventoryService.get();
        }
    }

    public InventoryService getInventoryService() {
        return this.inventoryService;
    }

    public void setInventoryService(InventoryService inventoryService) {
        this.inventoryService = inventoryService;
    }

    public void handle(String tenantId, List<BusinessTransaction> btxns) {
        this.log.tracef("Inventory Enricher called with: %s", btxns);
    }
}

