/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.cassandra;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.services.Criteria;

public class CassandraServiceUtil {
    protected static final String SEPARATOR = ":";

    public static List<String> toTagList(Map<String, String> map) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : map.keySet()) {
            String value = map.get(key);
            ret.add(key + SEPARATOR + value);
        }
        return ret;
    }

    public static List<String> toTagList(List<CorrelationIdentifier> cids) {
        ArrayList<String> ret = new ArrayList<String>();
        if (cids != null) {
            for (int i = 0; i < cids.size(); ++i) {
                CorrelationIdentifier cid = cids.get(i);
                ret.add(cid.getScope().name() + SEPARATOR + cid.getValue());
            }
        }
        return ret;
    }

    public static String whereClause(String tenantId, Criteria criteria) {
        StringBuilder ret = new StringBuilder();
        ret.append(" WHERE tenantId = '");
        ret.append(CassandraServiceUtil.tenant(tenantId));
        ret.append("'");
        ret.append(" AND ");
        ret.append("datetime >= ");
        ret.append(criteria.calculateStartTime());
        if (criteria.getEndTime() != 0L) {
            ret.append(" AND ");
            ret.append("datetime < ");
            ret.append(criteria.calculateEndTime());
        }
        if (criteria.getBusinessTransaction() != null) {
            ret.append(" AND ");
            ret.append("businessTransaction = '");
            ret.append(criteria.getBusinessTransaction());
            ret.append("'");
        }
        if (criteria.getHostName() != null && criteria.getHostName().trim().length() > 0) {
            ret.append(" AND ");
            ret.append("hostName = '");
            ret.append(criteria.getHostName());
            ret.append("'");
        }
        for (Criteria.PropertyCriteria pc : criteria.getProperties()) {
            if (pc.isExcluded()) continue;
            ret.append(" AND ");
            ret.append("properties CONTAINS '");
            ret.append(CassandraServiceUtil.propertyEncoding(pc));
            ret.append('\'');
        }
        for (CorrelationIdentifier ci : criteria.getCorrelationIds()) {
            ret.append(" AND ");
            ret.append("correlationIds CONTAINS '");
            ret.append(CassandraServiceUtil.propertyEncoding(ci));
            ret.append('\'');
        }
        for (Criteria.FaultCriteria fc : criteria.getFaults()) {
            if (fc.isExcluded()) continue;
            ret.append(" AND ");
            ret.append("fault = '");
            ret.append(fc.getValue());
            ret.append('\'');
        }
        if (ret.length() > 0) {
            return ret.toString();
        }
        return null;
    }

    public static String propertyEncoding(Criteria.PropertyCriteria pc) {
        return pc.getName() + SEPARATOR + pc.getValue();
    }

    public static String propertyEncoding(CorrelationIdentifier ci) {
        return ci.getScope().name() + SEPARATOR + ci.getValue();
    }

    public static String tenant(String id) {
        if (id == null) {
            return "default";
        }
        return id;
    }

    public static String emptyStringForNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static boolean exclude(Map<String, String> properties, String fault, Criteria criteria) {
        if (!criteria.getProperties().isEmpty()) {
            for (Criteria.PropertyCriteria pc : criteria.getProperties()) {
                if (!pc.isExcluded() || !properties.containsKey(pc.getName()) || !properties.get(pc.getName()).equals(pc.getValue())) continue;
                return true;
            }
        }
        if (!criteria.getFaults().isEmpty()) {
            for (Criteria.FaultCriteria fc : criteria.getFaults()) {
                if (!fc.isExcluded() || fault == null || !fault.equals(fc.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasExclusions(Criteria criteria) {
        if (!criteria.getProperties().isEmpty()) {
            for (Criteria.PropertyCriteria pc : criteria.getProperties()) {
                if (!pc.isExcluded()) continue;
                return true;
            }
        }
        if (!criteria.getFaults().isEmpty()) {
            for (Criteria.FaultCriteria fc : criteria.getFaults()) {
                if (!fc.isExcluded()) continue;
                return true;
            }
        }
        return false;
    }

    public static int getPosition(long startTime, long interval, long time) {
        return (int)((time - startTime) / interval);
    }

    public static long getBaseTimestamp(long startTime, long interval, int index) {
        return (long)((int)(startTime / interval)) * interval + interval * (long)index;
    }
}

