/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hawkular.btm.api.model.analytics.Cardinality;
import org.hawkular.btm.api.model.analytics.CommunicationSummaryStatistics;
import org.hawkular.btm.api.model.analytics.CompletionTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.NodeSummaryStatistics;
import org.hawkular.btm.api.model.analytics.NodeTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.Percentiles;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.NodeType;
import org.hawkular.btm.api.model.events.CommunicationDetails;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.api.model.events.NodeDetails;
import org.hawkular.btm.api.services.AbstractAnalyticsService;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.api.services.Criteria;
import org.hawkular.btm.server.cassandra.CassandraClient;
import org.hawkular.btm.server.cassandra.CassandraServiceUtil;
import org.hawkular.btm.server.cassandra.log.MsgLogger;

@Singleton
public class AnalyticsServiceCassandra
extends AbstractAnalyticsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final Logger log = Logger.getLogger(AnalyticsServiceCassandra.class.getName());
    private static final Logger perfLog = Logger.getLogger("org.hawkular.btm.performance.cassandra");
    private static ObjectMapper mapper = new ObjectMapper();
    private PreparedStatement insertCompletionTimes;
    private PreparedStatement insertNodeDetails;
    private PreparedStatement deleteCompletionTimes;
    private PreparedStatement deleteNodeDetails;
    @Inject
    private CassandraClient client;
    @Inject
    private BusinessTransactionService businessTransactionService;

    @PostConstruct
    public void init() {
        this.insertCompletionTimes = this.getClient().getSession().prepare("INSERT INTO hawkular_btm.completiontimes (tenantId, datetime, key, id, businessTransaction, fault, properties, doc) VALUES (?, ?, ?, ?, ?, ?, ?, ?);");
        this.insertNodeDetails = this.getClient().getSession().prepare("INSERT INTO hawkular_btm.nodedetails (tenantId, datetime, key, id, businessTransaction, uri, componentType, operation, fault, hostName, properties, details, correlationIds, doc) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
        this.deleteCompletionTimes = this.getClient().getSession().prepare("DELETE FROM hawkular_btm.completiontimes WHERE tenantId = ?;");
        this.deleteNodeDetails = this.getClient().getSession().prepare("DELETE FROM hawkular_btm.nodedetails WHERE tenantId = ?;");
    }

    public CassandraClient getClient() {
        return this.client;
    }

    public void setClient(CassandraClient client) {
        this.client = client;
    }

    public BusinessTransactionService getBusinessTransactionService() {
        return this.businessTransactionService;
    }

    public void setBusinessTransactionService(BusinessTransactionService bts) {
        this.businessTransactionService = bts;
    }

    protected List<BusinessTransaction> getFragments(String tenantId, Criteria criteria) {
        return this.businessTransactionService.query(tenantId, criteria);
    }

    protected boolean requiresFullEvaluation(Criteria criteria) {
        return CassandraServiceUtil.hasExclusions(criteria) || criteria.getLowerBound() > 0L || criteria.getUpperBound() > 0L;
    }

    protected boolean exclude(CompletionTime ct, Criteria criteria) {
        return CassandraServiceUtil.exclude(ct.getProperties(), ct.getFault(), criteria) || criteria.getLowerBound() > 0L && ct.getDuration() < criteria.getLowerBound() || criteria.getUpperBound() > 0L && ct.getDuration() > criteria.getUpperBound();
    }

    public long getCompletionCount(String tenantId, Criteria criteria) {
        StringBuilder statement = new StringBuilder();
        boolean fullEvaluation = this.requiresFullEvaluation(criteria);
        if (fullEvaluation) {
            statement.append("SELECT doc FROM hawkular_btm.completiontimes");
        } else {
            statement.append("SELECT count(*) FROM hawkular_btm.completiontimes");
        }
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Query statement = " + statement.toString());
        }
        long queryTime = 0L;
        if (log.isLoggable(Level.FINEST)) {
            queryTime = System.currentTimeMillis();
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results returned");
        }
        long ret = 0L;
        if (fullEvaluation) {
            for (Row row : results) {
                try {
                    CompletionTime ct = (CompletionTime)mapper.readValue(row.getString("doc"), CompletionTime.class);
                    if (this.exclude(ct, criteria)) continue;
                    ++ret;
                }
                catch (Exception e) {
                    this.msgLog.errorFailedToParse(e);
                }
            }
        } else {
            ret = results.one().getLong(0);
        }
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms");
        }
        return ret;
    }

    public long getCompletionFaultCount(String tenantId, Criteria criteria) {
        StringBuilder statement = new StringBuilder();
        boolean fullEvaluation = this.requiresFullEvaluation(criteria);
        if (fullEvaluation) {
            statement.append("SELECT doc FROM hawkular_btm.completiontimes");
        } else {
            statement.append("SELECT count(*) FROM hawkular_btm.completiontimes");
        }
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" AND fault = '' ALLOW FILTERING;");
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Query statement = " + statement.toString());
        }
        long queryTime = 0L;
        if (log.isLoggable(Level.FINEST)) {
            queryTime = System.currentTimeMillis();
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results returned");
        }
        long nofault = 0L;
        if (fullEvaluation) {
            for (Row row : results) {
                try {
                    CompletionTime ct = (CompletionTime)mapper.readValue(row.getString("doc"), CompletionTime.class);
                    if (this.exclude(ct, criteria)) continue;
                    ++nofault;
                }
                catch (Exception e) {
                    this.msgLog.errorFailedToParse(e);
                }
            }
        } else {
            nofault = results.one().getLong(0);
        }
        long count = this.getCompletionCount(tenantId, criteria);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Fault count: total count = " + count + " nofault count = " + nofault);
        }
        long ret = count - nofault;
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms");
        }
        return ret;
    }

    public Percentiles getCompletionPercentiles(String tenantId, Criteria criteria) {
        StringBuilder statement = new StringBuilder("SELECT doc FROM hawkular_btm.completiontimes");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Query statement = " + statement.toString());
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        double average = 0.0;
        long count = 0L;
        for (Row row : results) {
            try {
                CompletionTime ct = (CompletionTime)mapper.readValue(row.getString("doc"), CompletionTime.class);
                if (this.exclude(ct, criteria)) continue;
                average = (average * (double)count + (double)ct.getDuration()) / (double)(count + 1L);
                ++count;
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        Percentiles ret = new Percentiles();
        ret.getPercentiles().put(95, average);
        return ret;
    }

    public List<CompletionTimeseriesStatistics> getCompletionTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        long endTime = criteria.calculateEndTime();
        long startTime = CassandraServiceUtil.getBaseTimestamp(criteria.calculateStartTime(), interval, 0);
        criteria.setStartTime(startTime);
        long timeDiff = endTime - startTime;
        int numberOfEntries = Math.round(timeDiff / interval);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("NumberOfEntries=" + numberOfEntries + " startTime=" + startTime + " endTime=" + endTime + " timeDiff=" + timeDiff + " interval=" + interval);
        }
        CompletionTimeseriesStatistics[] stats = new CompletionTimeseriesStatistics[numberOfEntries + 3];
        StringBuilder statement = new StringBuilder("SELECT doc FROM hawkular_btm.completiontimes");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Query statement = " + statement.toString());
        }
        long queryTime = 0L;
        int numOfNodes = 0;
        if (log.isLoggable(Level.FINEST)) {
            queryTime = System.currentTimeMillis();
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results returned");
        }
        for (Row row : results) {
            if (log.isLoggable(Level.FINEST)) {
                ++numOfNodes;
            }
            try {
                CompletionTime ct = (CompletionTime)mapper.readValue(row.getString("doc"), CompletionTime.class);
                if (this.exclude(ct, criteria)) continue;
                int index = CassandraServiceUtil.getPosition(startTime, interval, ct.getTimestamp());
                if (stats[index] == null) {
                    stats[index] = new CompletionTimeseriesStatistics();
                    stats[index].setTimestamp(CassandraServiceUtil.getBaseTimestamp(startTime, interval, index));
                    stats[index].setMin(Double.MAX_VALUE);
                }
                stats[index].setAverage((stats[index].getAverage() * (double)stats[index].getCount() + (double)ct.getDuration()) / (double)(stats[index].getCount() + 1L));
                stats[index].setCount(stats[index].getCount() + 1L);
                if (ct.getFault() != null && ct.getFault().trim().length() > 0) {
                    stats[index].setFaultCount(stats[index].getFaultCount() + 1L);
                }
                if ((double)ct.getDuration() > stats[index].getMax()) {
                    stats[index].setMax((double)ct.getDuration());
                }
                if (!((double)ct.getDuration() < stats[index].getMin())) continue;
                stats[index].setMin((double)ct.getDuration());
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms and " + "number of nodes processed = " + numOfNodes);
        }
        ArrayList<CompletionTimeseriesStatistics> ret = new ArrayList<CompletionTimeseriesStatistics>();
        for (int i = 0; i < stats.length; ++i) {
            if (stats[i] == null) continue;
            ret.add(stats[i]);
        }
        return ret;
    }

    public List<Cardinality> getCompletionFaultDetails(String tenantId, Criteria criteria) {
        StringBuilder statement = new StringBuilder("SELECT doc FROM hawkular_btm.completiontimes");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Query statement = " + statement.toString());
        }
        long queryTime = 0L;
        int numOfNodes = 0;
        if (log.isLoggable(Level.FINEST)) {
            queryTime = System.currentTimeMillis();
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results returned");
        }
        HashMap<String, Cardinality> cards = new HashMap<String, Cardinality>();
        for (Row row : results) {
            try {
                CompletionTime ct = (CompletionTime)mapper.readValue(row.getString("doc"), CompletionTime.class);
                if (this.exclude(ct, criteria) || ct.getFault() == null || ct.getFault().trim().length() <= 0) continue;
                Cardinality card = (Cardinality)cards.get(ct.getFault());
                if (card == null) {
                    card = new Cardinality();
                    card.setValue(ct.getFault());
                    cards.put(ct.getFault(), card);
                }
                card.setCount(card.getCount() + 1L);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms and " + "number of nodes processed = " + numOfNodes);
        }
        ArrayList<Cardinality> ret = new ArrayList<Cardinality>(cards.values());
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return (int)(arg1.getCount() - arg0.getCount());
            }
        });
        return ret;
    }

    public List<Cardinality> getCompletionPropertyDetails(String tenantId, Criteria criteria, String property) {
        StringBuilder statement = new StringBuilder("SELECT doc FROM hawkular_btm.completiontimes");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Query statement = " + statement.toString());
        }
        long queryTime = 0L;
        int numOfNodes = 0;
        if (log.isLoggable(Level.FINEST)) {
            queryTime = System.currentTimeMillis();
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results returned");
        }
        HashMap<String, Cardinality> cards = new HashMap<String, Cardinality>();
        for (Row row : results) {
            try {
                CompletionTime ct = (CompletionTime)mapper.readValue(row.getString("doc"), CompletionTime.class);
                if (this.exclude(ct, criteria) || !ct.getProperties().containsKey(property)) continue;
                String value = (String)ct.getProperties().get(property);
                Cardinality card = (Cardinality)cards.get(value);
                if (card == null) {
                    card = new Cardinality();
                    card.setValue(value);
                    cards.put(value, card);
                }
                card.setCount(card.getCount() + 1L);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms and " + "number of nodes processed = " + numOfNodes);
        }
        ArrayList<Cardinality> ret = new ArrayList<Cardinality>(cards.values());
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return arg0.getValue().compareTo(arg1.getValue());
            }
        });
        return ret;
    }

    public int getAlertCount(String tenantId, String name) {
        return 0;
    }

    public List<NodeTimeseriesStatistics> getNodeTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        long endTime = criteria.calculateEndTime();
        long startTime = CassandraServiceUtil.getBaseTimestamp(criteria.calculateStartTime(), interval, 0);
        criteria.setStartTime(startTime);
        long timeDiff = endTime - startTime;
        int numberOfEntries = Math.round(timeDiff / interval);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("NumberOfEntries=" + numberOfEntries + " startTime=" + startTime + " endTime=" + endTime + " timeDiff=" + timeDiff + " interval=" + interval);
        }
        NodeTimeseriesStatistics[] stats = new NodeTimeseriesStatistics[numberOfEntries + 3];
        StringBuilder statement = new StringBuilder("SELECT doc FROM hawkular_btm.nodedetails");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Query statement = " + statement.toString());
        }
        long queryTime = 0L;
        int numOfNodes = 0;
        if (log.isLoggable(Level.FINEST)) {
            queryTime = System.currentTimeMillis();
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results returned");
        }
        for (Row row : results) {
            if (log.isLoggable(Level.FINEST)) {
                ++numOfNodes;
            }
            try {
                NodeTimeseriesStatistics.NodeComponentTypeStatistics ncts;
                NodeDetails nd = (NodeDetails)mapper.readValue(row.getString("doc"), NodeDetails.class);
                if (CassandraServiceUtil.exclude(nd.getProperties(), nd.getFault(), criteria)) continue;
                String componentType = null;
                componentType = nd.getType() == NodeType.Consumer ? "consumer" : (nd.getType() == NodeType.Producer ? "producer" : nd.getComponentType());
                int index = CassandraServiceUtil.getPosition(startTime, interval, nd.getTimestamp());
                if (stats[index] == null) {
                    stats[index] = new NodeTimeseriesStatistics();
                    stats[index].setTimestamp(CassandraServiceUtil.getBaseTimestamp(startTime, interval, index));
                }
                if ((ncts = (NodeTimeseriesStatistics.NodeComponentTypeStatistics)stats[index].getComponentTypes().get(componentType)) == null) {
                    ncts = new NodeTimeseriesStatistics.NodeComponentTypeStatistics();
                    stats[index].getComponentTypes().put(componentType, ncts);
                }
                ncts.setDuration((ncts.getDuration() * (double)ncts.getCount() + (double)nd.getActual()) / (double)(ncts.getCount() + 1L));
                ncts.setCount(ncts.getCount() + 1L);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms and " + "number of nodes processed = " + numOfNodes);
        }
        ArrayList<NodeTimeseriesStatistics> ret = new ArrayList<NodeTimeseriesStatistics>();
        for (int i = 0; i < stats.length; ++i) {
            if (stats[i] == null) continue;
            ret.add(stats[i]);
        }
        return ret;
    }

    public Collection<NodeSummaryStatistics> getNodeSummaryStatistics(String tenantId, Criteria criteria) {
        HashMap<String, NodeSummaryStatistics> intermediate = new HashMap<String, NodeSummaryStatistics>();
        StringBuilder statement = new StringBuilder("SELECT doc FROM hawkular_btm.nodedetails");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Query statement = " + statement.toString());
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        for (Row row : results) {
            try {
                NodeDetails nd = (NodeDetails)mapper.readValue(row.getString("doc"), NodeDetails.class);
                if (CassandraServiceUtil.exclude(nd.getProperties(), nd.getFault(), criteria)) continue;
                String key = AnalyticsServiceCassandra.nodeDetailsKey(nd);
                NodeSummaryStatistics summary = (NodeSummaryStatistics)intermediate.get(key);
                if (summary == null) {
                    summary = new NodeSummaryStatistics();
                    if (nd.getType() == NodeType.Consumer) {
                        summary.setComponentType("consumer");
                    } else if (nd.getType() == NodeType.Producer) {
                        summary.setComponentType("producer");
                    } else {
                        summary.setComponentType(nd.getComponentType());
                    }
                    summary.setUri(nd.getUri());
                    summary.setOperation(nd.getOperation());
                    intermediate.put(key, summary);
                }
                summary.setActual((summary.getActual() * (double)summary.getCount() + (double)nd.getActual()) / (double)(summary.getCount() + 1L));
                summary.setElapsed((summary.getElapsed() * (double)summary.getCount() + (double)nd.getElapsed()) / (double)(summary.getCount() + 1L));
                summary.setCount(summary.getCount() + 1L);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        return intermediate.values();
    }

    protected static String nodeDetailsKey(NodeDetails nd) {
        return nd.getType() + ":" + nd.getComponentType() + ":" + nd.getUri() + ":" + nd.getOperation();
    }

    public Collection<CommunicationSummaryStatistics> getCommunicationSummaryStatistics(String tenantId, Criteria criteria) {
        return null;
    }

    public void storeCommunicationDetails(String tenantId, List<CommunicationDetails> communicationDetails) throws Exception {
    }

    public void storeNodeDetails(String tenantId, List<NodeDetails> nodeDetails) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Store node details (tenantId=" + tenantId + "):" + nodeDetails);
        }
        BatchStatement batch = new BatchStatement();
        for (int i = 0; i < nodeDetails.size(); ++i) {
            NodeDetails details = nodeDetails.get(i);
            batch.add((Statement)new BoundStatement(this.insertNodeDetails).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), new Date(details.getTimestamp()), UUID.randomUUID(), details.getId(), details.getBusinessTransaction(), details.getUri(), details.getComponentType(), details.getOperation(), details.getFault(), details.getHostName(), CassandraServiceUtil.toTagList(details.getProperties()), CassandraServiceUtil.toTagList(details.getDetails()), CassandraServiceUtil.toTagList(details.getCorrelationIds()), mapper.writeValueAsString((Object)details)}));
        }
        this.getClient().getSession().execute((Statement)batch);
    }

    public void storeBTxnCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Store completion times (tenantId=" + tenantId + "):" + completionTimes);
        }
        BatchStatement batch = new BatchStatement();
        for (int i = 0; i < completionTimes.size(); ++i) {
            CompletionTime completionTime = completionTimes.get(i);
            batch.add((Statement)new BoundStatement(this.insertCompletionTimes).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), new Date(completionTime.getTimestamp()), UUID.randomUUID(), completionTime.getId(), completionTime.getBusinessTransaction(), this.valueOrEmptyString(completionTime.getFault()), CassandraServiceUtil.toTagList(completionTime.getProperties()), mapper.writeValueAsString((Object)completionTime)}));
        }
        this.getClient().getSession().execute((Statement)batch);
    }

    public void storeFragmentCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws Exception {
    }

    protected String valueOrEmptyString(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public List<String> getHostNames(String tenantId, Criteria criteria) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder statement = new StringBuilder("SELECT hostName FROM hawkular_btm.businesstransactions");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(";");
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        for (Row row : results) {
            String hostName = row.getString("hostName");
            if (ret.contains(hostName)) continue;
            ret.add(hostName);
        }
        Collections.sort(ret);
        return ret;
    }

    public void clear(String tenantId) {
        this.client.getSession().execute((Statement)new BoundStatement(this.deleteCompletionTimes).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
        this.client.getSession().execute((Statement)new BoundStatement(this.deleteNodeDetails).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
    }
}

