/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnSummary;
import org.hawkular.btm.api.model.config.btxn.ConfigMessage;
import org.hawkular.btm.api.services.AbstractConfigurationService;
import org.hawkular.btm.api.services.ConfigurationLoader;
import org.hawkular.btm.server.cassandra.CassandraClient;
import org.hawkular.btm.server.cassandra.CassandraServiceUtil;
import org.hawkular.btm.server.cassandra.log.MsgLogger;

@Singleton
public class ConfigurationServiceCassandra
extends AbstractConfigurationService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static ObjectMapper mapper = new ObjectMapper();
    private PreparedStatement getBusinessTxnConfig;
    private PreparedStatement getBusinessTxnConfigInvalid;
    private PreparedStatement getBusinessTxnConfigs;
    private PreparedStatement getBusinessTxnConfigsInvalid;
    private PreparedStatement insertBusinessTxnConfig;
    private PreparedStatement insertBusinessTxnConfigInvalid;
    private PreparedStatement deleteBusinessTxnConfigInvalid;
    private PreparedStatement deleteAllBTxnConfig;
    private PreparedStatement deleteAllBTxnConfigInvalid;
    @Inject
    private CassandraClient client;

    public CassandraClient getClient() {
        return this.client;
    }

    public void setClient(CassandraClient client) {
        this.client = client;
    }

    @PostConstruct
    public void init() {
        this.getBusinessTxnConfig = this.client.getSession().prepare("SELECT doc FROM hawkular_btm.businesstxnconfig WHERE tenantId = ? AND id = ?;");
        this.getBusinessTxnConfigInvalid = this.client.getSession().prepare("SELECT doc FROM hawkular_btm.businesstxnconfiginvalid WHERE tenantId = ? AND id = ?;");
        this.getBusinessTxnConfigs = this.client.getSession().prepare("SELECT id, doc FROM hawkular_btm.businesstxnconfig WHERE tenantId = ?;");
        this.getBusinessTxnConfigsInvalid = this.client.getSession().prepare("SELECT id, doc FROM hawkular_btm.businesstxnconfiginvalid WHERE tenantId = ?;");
        this.insertBusinessTxnConfig = this.client.getSession().prepare("INSERT INTO hawkular_btm.businesstxnconfig (tenantId, id, doc) VALUES (?, ?, ?);");
        this.insertBusinessTxnConfigInvalid = this.client.getSession().prepare("INSERT INTO hawkular_btm.businesstxnconfiginvalid (tenantId, id, doc) VALUES (?, ?, ?);");
        this.deleteBusinessTxnConfigInvalid = this.client.getSession().prepare("DELETE FROM hawkular_btm.businesstxnconfiginvalid WHERE tenantId = ? AND id = ?;");
        this.deleteAllBTxnConfig = this.client.getSession().prepare("DELETE FROM hawkular_btm.businesstxnconfig WHERE tenantId = ?;");
        this.deleteAllBTxnConfigInvalid = this.client.getSession().prepare("DELETE FROM hawkular_btm.businesstxnconfiginvalid WHERE tenantId = ?;");
    }

    public CollectorConfiguration getCollector(String tenantId, String host, String server) {
        CollectorConfiguration config = ConfigurationLoader.getConfiguration();
        ResultSet results = this.client.getSession().execute((Statement)new BoundStatement(this.getBusinessTxnConfigs).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
        for (Row row : results) {
            try {
                BusinessTxnConfig btc = (BusinessTxnConfig)mapper.readValue(row.getString("doc"), BusinessTxnConfig.class);
                if (btc.isDeleted()) continue;
                config.getBusinessTransactions().put(row.getString("id"), btc);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        return config;
    }

    public List<ConfigMessage> setBusinessTransaction(String tenantId, String name, BusinessTxnConfig config) throws Exception {
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Update business transaction config with name[%s] config=%s", name, config);
        }
        List messages = this.validateBusinessTransaction(config);
        config.setLastUpdated(System.currentTimeMillis());
        PreparedStatement statement = messages.isEmpty() ? this.insertBusinessTxnConfig : this.insertBusinessTxnConfigInvalid;
        this.client.getSession().execute((Statement)new BoundStatement(statement).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), name, mapper.writeValueAsString((Object)config)}));
        if (messages.isEmpty()) {
            this.client.getSession().execute((Statement)new BoundStatement(this.deleteBusinessTxnConfigInvalid).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), name}));
        }
        return messages;
    }

    public BusinessTxnConfig getBusinessTransaction(String tenantId, String name) {
        ResultSet results = this.client.getSession().execute((Statement)new BoundStatement(this.getBusinessTxnConfigInvalid).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), name}));
        Row row = results.one();
        if (row == null) {
            results = this.client.getSession().execute((Statement)new BoundStatement(this.getBusinessTxnConfig).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), name}));
            row = results.one();
        }
        if (row != null) {
            try {
                BusinessTxnConfig btc = (BusinessTxnConfig)mapper.readValue(row.getString("doc"), BusinessTxnConfig.class);
                if (!btc.isDeleted()) {
                    return btc;
                }
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        return null;
    }

    public Map<String, BusinessTxnConfig> getBusinessTransactions(String tenantId, long updated) {
        HashMap<String, BusinessTxnConfig> ret = new HashMap<String, BusinessTxnConfig>();
        ResultSet results = this.client.getSession().execute((Statement)new BoundStatement(this.getBusinessTxnConfigs).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
        for (Row row : results) {
            try {
                BusinessTxnConfig btc = (BusinessTxnConfig)mapper.readValue(row.getString("doc"), BusinessTxnConfig.class);
                if ((updated != 0L || btc.isDeleted()) && (updated <= 0L || btc.getLastUpdated() <= updated)) continue;
                ret.put(row.getString("id"), btc);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        return ret;
    }

    public List<BusinessTxnSummary> getBusinessTransactionSummaries(String tenantId) {
        BusinessTxnConfig btc;
        ArrayList<BusinessTxnSummary> ret = new ArrayList<BusinessTxnSummary>();
        ArrayList<String> names = new ArrayList<String>();
        ResultSet results = this.client.getSession().execute((Statement)new BoundStatement(this.getBusinessTxnConfigs).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
        for (Row row : results) {
            try {
                btc = (BusinessTxnConfig)mapper.readValue(row.getString("doc"), BusinessTxnConfig.class);
                if (btc.isDeleted()) continue;
                BusinessTxnSummary summary = new BusinessTxnSummary();
                summary.setName(row.getString("id"));
                summary.setDescription(btc.getDescription());
                summary.setLevel(btc.getLevel());
                ret.add(summary);
                names.add(summary.getName());
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        results = this.client.getSession().execute((Statement)new BoundStatement(this.getBusinessTxnConfigsInvalid).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
        for (Row row : results) {
            try {
                btc = (BusinessTxnConfig)mapper.readValue(row.getString("doc"), BusinessTxnConfig.class);
                String name = row.getString("id");
                if (names.contains(name)) continue;
                BusinessTxnSummary summary = new BusinessTxnSummary();
                summary.setName(name);
                summary.setDescription(btc.getDescription());
                summary.setLevel(btc.getLevel());
                ret.add(summary);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        return ret;
    }

    public void removeBusinessTransaction(String tenantId, String name) throws Exception {
        BusinessTxnConfig config = new BusinessTxnConfig();
        config.setDeleted(true);
        config.setLastUpdated(System.currentTimeMillis());
        this.client.getSession().execute((Statement)new BoundStatement(this.insertBusinessTxnConfig).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), name, mapper.writeValueAsString((Object)config)}));
        this.client.getSession().execute((Statement)new BoundStatement(this.deleteBusinessTxnConfigInvalid).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), name}));
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Remove business transaction config with name[%s]", name);
        }
    }

    public void clear(String tenantId) {
        this.client.getSession().execute((Statement)new BoundStatement(this.deleteAllBTxnConfig).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
        this.client.getSession().execute((Statement)new BoundStatement(this.deleteAllBTxnConfigInvalid).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
    }
}

