/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionService;

@MessageDriven(name="BusinessTransactions_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="BusinessTransactions")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class BusinessTransactionStoreMDB
implements MessageListener {
    private static final Logger log = Logger.getLogger(BusinessTransactionStoreMDB.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    @Inject
    private BusinessTransactionService businessTransactionService;

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Business transactions received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            String data = ((TextMessage)message).getText();
            List btxns = (List)mapper.readValue(data, BUSINESS_TXN_LIST);
            this.businessTransactionService.storeBusinessTransactions(tenantId, btxns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

