/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.btm.api.model.analytics.CompletionTime;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionPublisher;
import org.hawkular.btm.processor.completiontime.CompletionTimeDeriver;
import org.hawkular.btm.server.api.services.CompletionTimePublisher;
import org.hawkular.btm.server.api.task.Handler;
import org.hawkular.btm.server.api.task.ProcessingUnit;
import org.hawkular.btm.server.api.task.Processor;

@MessageDriven(name="BusinessTransaction_CompletionTimeDeriver", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="BusinessTransactions")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class CompletionTimeDeriverMDB
implements MessageListener {
    private static final Logger log = Logger.getLogger(CompletionTimeDeriverMDB.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    private static CompletionTimeDeriver processor = new CompletionTimeDeriver();
    @Inject
    private BusinessTransactionPublisher businessTransactionPublisher;
    @Inject
    private CompletionTimePublisher completionTimePublisher;

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("CompletionTimeDeriver received=" + message);
        }
        try {
            final String tenantId = message.getStringProperty("tenant");
            int retryCount = message.propertyExists("retryCount") ? message.getIntProperty("retryCount") : 3;
            String data = ((TextMessage)message).getText();
            List btxns = (List)mapper.readValue(data, BUSINESS_TXN_LIST);
            ProcessingUnit pu = new ProcessingUnit();
            pu.setProcessor((Processor)processor);
            pu.setRetryCount(retryCount);
            pu.setResultHandler((Handler)new Handler<CompletionTime>(){

                public void handle(List<CompletionTime> items) throws Exception {
                    CompletionTimeDeriverMDB.this.completionTimePublisher.publish(tenantId, items);
                }
            });
            pu.setRetryHandler((Handler)new Handler<BusinessTransaction>(){

                public void handle(List<BusinessTransaction> items) throws Exception {
                    CompletionTimeDeriverMDB.this.businessTransactionPublisher.publish(tenantId, items);
                }
            });
            pu.handle(btxns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

