/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.btm.api.model.analytics.CompletionTime;
import org.hawkular.btm.api.services.AnalyticsService;

@MessageDriven(name="CompletionTimes_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="CompletionTimes")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class CompletionTimeStoreMDB
implements MessageListener {
    private static final Logger log = Logger.getLogger(CompletionTimeStoreMDB.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<CompletionTime>> COMPLETION_TIME_LIST = new TypeReference<List<CompletionTime>>(){};
    @Inject
    private AnalyticsService analyticsService;

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Completion time received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            String data = ((TextMessage)message).getText();
            List cts = (List)mapper.readValue(data, COMPLETION_TIME_LIST);
            this.analyticsService.storeCompletionTimes(tenantId, cts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

