/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.btm.api.model.analytics.ResponseTime;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionPublisher;
import org.hawkular.btm.processor.responsetime.ResponseTimeDeriver;
import org.hawkular.btm.server.api.services.ResponseTimePublisher;
import org.hawkular.btm.server.api.task.Handler;
import org.hawkular.btm.server.api.task.ProcessingUnit;
import org.hawkular.btm.server.api.task.Processor;

@MessageDriven(name="BusinessTransaction_ResponseTimeDeriver", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="BusinessTransactions")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class ResponseTimeDeriverMDB
implements MessageListener {
    private static final Logger log = Logger.getLogger(ResponseTimeDeriverMDB.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    private static ResponseTimeDeriver processor = new ResponseTimeDeriver();
    @Inject
    private BusinessTransactionPublisher businessTransactionPublisher;
    @Inject
    private ResponseTimePublisher responseTimePublisher;

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ResponseTimeDeriver received=" + message);
        }
        try {
            final String tenantId = message.getStringProperty("tenant");
            int retryCount = message.propertyExists("retryCount") ? message.getIntProperty("retryCount") : 3;
            String data = ((TextMessage)message).getText();
            List btxns = (List)mapper.readValue(data, BUSINESS_TXN_LIST);
            ProcessingUnit pu = new ProcessingUnit();
            pu.setProcessor((Processor)processor);
            pu.setRetryCount(retryCount);
            pu.setResultHandler((Handler)new Handler<ResponseTime>(){

                public void handle(List<ResponseTime> items) throws Exception {
                    ResponseTimeDeriverMDB.this.responseTimePublisher.publish(tenantId, items);
                }
            });
            pu.setRetryHandler((Handler)new Handler<BusinessTransaction>(){

                public void handle(List<BusinessTransaction> items) throws Exception {
                    ResponseTimeDeriverMDB.this.businessTransactionPublisher.publish(tenantId, items);
                }
            });
            pu.handle(btxns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

