/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.server.jms.BusinessTransactionPublisherJMS;
import org.hawkular.btm.server.jms.RetryCapableMDB;

@MessageDriven(name="BusinessTransactions_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="BusinessTransactions"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientId", propertyValue="BusinessTransactionStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="BusinessTransactionStore")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class BusinessTransactionStoreMDB
extends RetryCapableMDB<BusinessTransaction> {
    private static final Logger perfLog = Logger.getLogger("org.hawkular.btm.performance.btxn");
    @Inject
    private BusinessTransactionPublisherJMS businessTransactionPublisher;
    @Inject
    private BusinessTransactionService businessTransactionService;

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.businessTransactionPublisher);
        this.setTypeReference(new TypeReference<List<BusinessTransaction>>(){});
    }

    @Override
    protected void process(String tenantId, List<BusinessTransaction> items, int retryCount) throws Exception {
        long startTime = 0L;
        if (perfLog.isLoggable(Level.FINEST)) {
            startTime = System.currentTimeMillis();
            perfLog.finest("Performance: about to store btxn (first id=" + items.get(0).getId() + ")");
        }
        this.businessTransactionService.storeBusinessTransactions(tenantId, items);
        if (perfLog.isLoggable(Level.FINEST)) {
            perfLog.finest("Performance: store btxn (first id=" + items.get(0).getId() + ") duration=" + (System.currentTimeMillis() - startTime) + "ms");
        }
    }
}

