/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.server.jms.BTxnCompletionTimePublisherJMS;
import org.hawkular.btm.server.jms.RetryCapableMDB;

@MessageDriven(name="BTxnCompletionTimes_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="BTxnCompletionTimes"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="BTxnCompletionTimeStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="BTxnCompletionTimeStore")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class BTxnCompletionTimeStoreMDB
extends RetryCapableMDB<CompletionTime> {
    @Inject
    private BTxnCompletionTimePublisherJMS btxnCompletionTimePublisher;
    @Inject
    private AnalyticsService analyticsService;

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.btxnCompletionTimePublisher);
        this.setTypeReference(new TypeReference<List<CompletionTime>>(){});
    }

    @Override
    protected void process(String tenantId, List<CompletionTime> items, int retryCount) throws Exception {
        this.analyticsService.storeBTxnCompletionTimes(tenantId, items);
    }
}

