/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import java.util.List;
import org.hawkular.btm.api.services.Publisher;
import org.hawkular.btm.server.api.task.Handler;
import org.hawkular.btm.server.api.task.ProcessingUnit;
import org.hawkular.btm.server.api.task.Processor;
import org.hawkular.btm.server.jms.RetryCapableMDB;

public abstract class ProcessorMDB<S, T>
extends RetryCapableMDB<S> {
    private Processor<S, T> processor;
    private Publisher<T> publisher;

    public Processor<S, T> getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor<S, T> processor) {
        this.processor = processor;
    }

    public Publisher<T> getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Publisher<T> publisher) {
        this.publisher = publisher;
    }

    @Override
    protected void process(final String tenantId, List<S> items, int retryCount) throws Exception {
        final ProcessingUnit pu = new ProcessingUnit();
        pu.setProcessor(this.getProcessor());
        pu.setRetryCount(retryCount);
        pu.setResultHandler(new Handler<T>(){

            public void handle(List<T> items) throws Exception {
                ProcessorMDB.this.getPublisher().publish(tenantId, items);
            }
        });
        pu.setRetryHandler(new Handler<S>(){

            public void handle(List<S> items) throws Exception {
                ProcessorMDB.this.getRetryPublisher().publish(tenantId, items, pu.getRetryCount() - 1);
            }
        });
        pu.handle(items);
    }
}

