/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.model.events.NodeDetails;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.server.jms.NodeDetailsPublisherJMS;
import org.hawkular.btm.server.jms.RetryCapableMDB;

@MessageDriven(name="NodeDetails_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="NodeDetails"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="NodeDetailsStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="NodeDetailsStore")})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class NodeDetailsStoreMDB
extends RetryCapableMDB<NodeDetails> {
    @Inject
    private NodeDetailsPublisherJMS nodeDetailsPublisher;
    @Inject
    private AnalyticsService analyticsService;

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.nodeDetailsPublisher);
        this.setTypeReference(new TypeReference<List<NodeDetails>>(){});
    }

    @Override
    protected void process(String tenantId, List<NodeDetails> items, int retryCount) throws Exception {
        this.analyticsService.storeNodeDetails(tenantId, items);
    }
}

