/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.hawkular.btm.api.model.admin.CollectorConfiguration;
import org.hawkular.btm.api.services.AdminService;
import org.hawkular.btm.server.api.security.SecurityProvider;
import org.jboss.logging.Logger;

@Path(value="admin")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="admin", description="Administration")
public class AdminHandler {
    private static final Logger log = Logger.getLogger(AdminHandler.class);
    @Inject
    SecurityProvider securityProvider;
    @Inject
    AdminService adminService;

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the collector configuration for the optionally specified host and server", response=CollectorConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getConfiguration(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="optional host name") @QueryParam(value="host") String host, @ApiParam(required=false, value="optional server name") @QueryParam(value="server") String server) {
        try {
            log.tracef("Get collector configuration for host [%s] server [%s]", (Object)host, (Object)server);
            CollectorConfiguration config = this.adminService.getConfiguration(this.securityProvider.getTenantId(context), host, server);
            log.tracef("Got collector configuration for host [%s] server [%s] config=[%s]", (Object)host, (Object)server, (Object)config);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)config).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

