/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.BusinessTransactionPublisher;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.server.api.security.SecurityProvider;
import org.jboss.logging.Logger;

@Path(value="transactions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="transactions", description="Report/Query Business Transactions")
public class BusinessTransactionHandler {
    private static final Logger log = Logger.getLogger(BusinessTransactionHandler.class);
    @Inject
    SecurityProvider securityProvider;
    @Inject
    BusinessTransactionService btxnService;
    @Inject
    BusinessTransactionPublisher btxnPublisher;

    @POST
    @ApiOperation(value="Add a list of business transactions")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding business transactions succeeded."), @ApiResponse(code=500, message="Unexpected error happened while storing the business transactions")})
    public void addBusinessTransactions(@Context SecurityContext context, @Suspended AsyncResponse response, @HeaderParam(value="tenantId") String tenantId, @ApiParam(value="List of business transactions", required=true) List<BusinessTransaction> btxns) {
        try {
            this.btxnPublisher.publish(this.securityProvider.getTenantId(context), btxns);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
        }
        catch (Throwable t) {
            log.debugf(t.getMessage(), (Object)t);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + t.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve business transaction fragment for specified id", response=BusinessTransaction.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, business transaction found and returned"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Unknown business transaction id")})
    public void getBusinessTransaction(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="id of required business transaction") @PathParam(value="id") String id) {
        try {
            BusinessTransaction btxn = this.btxnService.get(this.securityProvider.getTenantId(context), id);
            if (btxn == null) {
                log.tracef("Business transaction '" + id + "' not found", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.tracef("Business transaction '" + id + "' found", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)btxn).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Query business transaction fragments associated with criteria", response=BusinessTransaction.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void queryBusinessTransactions(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="retrieve business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="retrieve business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="retrieve business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="retrieve business transactions with these correlation identifiers, defined as a comma separated list of scope|value pairs") @DefaultValue(value="") @QueryParam(value="correlations") String correlations) {
        try {
            BusinessTransactionCriteria criteria = new BusinessTransactionCriteria();
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            BusinessTransactionHandler.decodeProperties(criteria.getProperties(), properties);
            BusinessTransactionHandler.decodeCorrelationIdentifiers(criteria.getCorrelationIds(), correlations);
            log.tracef("Query Business transactions for criteria [%s]", (Object)criteria);
            List btxns = this.btxnService.query(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Queried Business transactions for criteria [%s] = %s", (Object)criteria, (Object)btxns);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)btxns).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    protected static void decodeProperties(Map<String, String> properties, String encoded) {
        if (encoded != null && encoded.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] parts = token.split("[|]");
                if (parts.length != 2) continue;
                String name = parts[0].trim();
                String value = parts[1].trim();
                log.tracef("Extracted property name [%s] value [%s]", (Object)name, (Object)value);
                properties.put(name, value);
            }
        }
    }

    protected static void decodeCorrelationIdentifiers(Set<CorrelationIdentifier> correlations, String encoded) {
        if (encoded != null && encoded.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] parts = token.split("[|]");
                if (parts.length != 2) continue;
                String scope = parts[0].trim();
                String value = parts[1].trim();
                log.tracef("Extracted correlation identifier scope [%s] value [%s]", (Object)scope, (Object)value);
                CorrelationIdentifier cid = new CorrelationIdentifier();
                cid.setScope(CorrelationIdentifier.Scope.valueOf((String)scope));
                cid.setValue(value);
                correlations.add(cid);
            }
        }
    }
}

