/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.hawkular.btm.api.model.analytics.Percentiles;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.server.api.security.SecurityProvider;
import org.hawkular.btm.server.rest.BusinessTransactionHandler;
import org.jboss.logging.Logger;

@Path(value="analytics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="analytics", description="Analytics")
public class AnalyticsHandler {
    private static final Logger log = Logger.getLogger(AnalyticsHandler.class);
    @Inject
    SecurityProvider securityProvider;
    @Inject
    AnalyticsService analyticsService;

    @GET
    @Path(value="businesstxn/unbounduris")
    @Produces(value={"application/json"})
    @ApiOperation(value="Identify the unbound URIs", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getUnboundURIs(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="optional 'start' time, default 1 hour before current time") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="optional 'end' time, default current time") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime) {
        try {
            log.tracef("Get unbound URIs: start [%s] end [%s]", startTime, endTime);
            List uris = this.analyticsService.getUnboundURIs(this.securityProvider.getTenantId(context), startTime, endTime);
            log.tracef("Got unbound URIs: start [%s] end [%s] = [%s]", startTime, endTime, (Object)uris);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)uris).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="businesstxn/bounduris/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Identify the bound URIs for a business transaction", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getBoundURIs(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name, @ApiParam(required=false, value="optional 'start' time, default 1 hour before current time") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="optional 'end' time, default current time") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime) {
        try {
            log.tracef("Get bound URIs: name [%s] start [%s] end [%s]", (Object)name, (Object)startTime, (Object)endTime);
            List uris = this.analyticsService.getBoundURIs(this.securityProvider.getTenantId(context), name, startTime, endTime);
            log.tracef("Got bound URIs: name [%s] start [%s] end [%s] = [%s]", new Object[]{name, startTime, endTime, uris});
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)uris).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="businesstxn/completion/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion count", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionCount(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="name") String name, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties) {
        try {
            BusinessTransactionCriteria criteria = new BusinessTransactionCriteria();
            criteria.setName(name);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            BusinessTransactionHandler.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get business transaction count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getCompletionCount(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got transaction count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="businesstxn/completion/faultcount")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the number of business transaction instances that returned a fault", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionFaultCount(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="name") String name, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties) {
        try {
            BusinessTransactionCriteria criteria = new BusinessTransactionCriteria();
            criteria.setName(name);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            BusinessTransactionHandler.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get business transaction fault count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getCompletionFaultCount(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got transaction fault count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="businesstxn/completion/percentiles")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion percentiles associated with criteria", response=Percentiles.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionPercentiles(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="name") String name, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties) {
        try {
            BusinessTransactionCriteria criteria = new BusinessTransactionCriteria();
            criteria.setName(name);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            BusinessTransactionHandler.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get business transaction completion percentiles for criteria [%s]", (Object)criteria);
            Percentiles stats = this.analyticsService.getCompletionPercentiles(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got business transaction completion percentiles for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="alerts/count/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction alert count", response=Integer.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getAlertCount(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name) {
        try {
            log.tracef("Get alert count: name [%s]", (Object)name);
            int count = this.analyticsService.getAlertCount(this.securityProvider.getTenantId(context), name);
            log.tracef("Got alert count: name [%s] = [%s]", (Object)name, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

