/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.hawkular.btm.api.model.analytics.Percentiles;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.api.services.BaseCriteria;
import org.hawkular.btm.api.services.CompletionTimeCriteria;
import org.hawkular.btm.api.services.NodeCriteria;
import org.hawkular.btm.server.api.security.SecurityProvider;
import org.hawkular.btm.server.rest.RESTServiceUtil;
import org.jboss.logging.Logger;

@Path(value="analytics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="analytics", description="Analytics")
public class AnalyticsHandler {
    private static final Logger log = Logger.getLogger(AnalyticsHandler.class);
    @Inject
    SecurityProvider securityProvider;
    @Inject
    AnalyticsService analyticsService;

    @GET
    @Path(value="unbounduris")
    @Produces(value={"application/json"})
    @ApiOperation(value="Identify the unbound URIs", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getUnboundURIs(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="optional 'start' time, default 1 hour before current time") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="optional 'end' time, default current time") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="compress list to show common patterns") @DefaultValue(value="false") @QueryParam(value="compress") boolean compress) {
        try {
            log.tracef("Get unbound URIs: start [%s] end [%s]", startTime, endTime);
            List uris = this.analyticsService.getUnboundURIs(this.securityProvider.getTenantId(context), startTime, endTime, compress);
            log.tracef("Got unbound URIs: start [%s] end [%s] = [%s]", startTime, endTime, (Object)uris);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)uris).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="bounduris/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Identify the bound URIs for a business transaction", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getBoundURIs(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name, @ApiParam(required=false, value="optional 'start' time, default 1 hour before current time") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="optional 'end' time, default current time") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime) {
        try {
            log.tracef("Get bound URIs: name [%s] start [%s] end [%s]", (Object)name, (Object)startTime, (Object)endTime);
            List uris = this.analyticsService.getBoundURIs(this.securityProvider.getTenantId(context), name, startTime, endTime);
            log.tracef("Got bound URIs: name [%s] start [%s] end [%s] = [%s]", new Object[]{name, startTime, endTime, uris});
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)uris).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="properties/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the properties used by a business transaction", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getPropertyInfo(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name, @ApiParam(required=false, value="optional 'start' time, default 1 hour before current time") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="optional 'end' time, default current time") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime) {
        try {
            log.tracef("Get property info: name [%s] start [%s] end [%s]", (Object)name, (Object)startTime, (Object)endTime);
            List pis = this.analyticsService.getPropertyInfo(this.securityProvider.getTenantId(context), name, startTime, endTime);
            log.tracef("Got property info: name [%s] start [%s] end [%s] = [%s]", new Object[]{name, startTime, endTime, pis});
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)pis).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="completion/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion count", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionCount(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            CompletionTimeCriteria criteria = new CompletionTimeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get business transaction count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getCompletionCount(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got transaction count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="completion/faultcount")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the number of business transaction instances that returned a fault", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionFaultCount(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            CompletionTimeCriteria criteria = new CompletionTimeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get business transaction fault count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getCompletionFaultCount(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got transaction fault count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="completion/percentiles")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion percentiles associated with criteria", response=Percentiles.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionPercentiles(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            CompletionTimeCriteria criteria = new CompletionTimeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get business transaction completion percentiles for criteria [%s]", (Object)criteria);
            Percentiles stats = this.analyticsService.getCompletionPercentiles(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got business transaction completion percentiles for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="completion/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionTimeseriesStatistics(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            CompletionTimeCriteria criteria = new CompletionTimeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get business transaction completion timeseries statistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            List stats = this.analyticsService.getCompletionTimeseriesStatistics(this.securityProvider.getTenantId(context), criteria, interval);
            log.tracef("Got business transaction completion timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="completion/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionTimeseriesStatistics(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval, @ApiParam(required=true, value="query criteria") CompletionTimeCriteria criteria) {
        try {
            log.tracef("Get business transaction completion timeseries statistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            List stats = this.analyticsService.getCompletionTimeseriesStatistics(this.securityProvider.getTenantId(context), criteria, interval);
            log.tracef("Got business transaction completion timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="completion/faults")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion fault details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionFaultDetails(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            CompletionTimeCriteria criteria = new CompletionTimeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get business transaction completion fault details for criteria (GET) [%s]", (Object)criteria);
            List cards = this.analyticsService.getCompletionFaultDetails(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got business transaction completion fault details for criteria (GET) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="completion/faults")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion fault details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionFaultDetails(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") CompletionTimeCriteria criteria) {
        try {
            log.tracef("Get business transaction completion fault details for criteria (POST) [%s]", (Object)criteria);
            List cards = this.analyticsService.getCompletionFaultDetails(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got business transaction completion fault details for criteria (POST) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="completion/property/{property}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion property details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionPropertyDetails(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults, @ApiParam(required=false, value="property") @PathParam(value="property") String property) {
        try {
            CompletionTimeCriteria criteria = new CompletionTimeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get business transaction completion property details for criteria (GET) [%s] property [%s]", (Object)criteria, (Object)property);
            List cards = this.analyticsService.getCompletionPropertyDetails(this.securityProvider.getTenantId(context), criteria, property);
            log.tracef("Got business transaction completion property details for criteria (GET) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="completion/property/{property}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction completion property details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCompletionPropertyDetails(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="property") @PathParam(value="property") String property, @ApiParam(required=true, value="query criteria") CompletionTimeCriteria criteria) {
        try {
            log.tracef("Get business transaction completion property details for criteria (POST) [%s] property [%s]", (Object)criteria, (Object)property);
            List cards = this.analyticsService.getCompletionPropertyDetails(this.securityProvider.getTenantId(context), criteria, property);
            log.tracef("Got business transaction completion property details for criteria (POST) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="alerts/count/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction alert count", response=Integer.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getAlertCount(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name) {
        try {
            log.tracef("Get alert count: name [%s]", (Object)name);
            int count = this.analyticsService.getAlertCount(this.securityProvider.getTenantId(context), name);
            log.tracef("Got alert count: name [%s] = [%s]", (Object)name, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="node/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction node timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeTimeseriesStatistics(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval) {
        try {
            NodeCriteria criteria = new NodeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get business transaction node timeseriesstatistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            List stats = this.analyticsService.getNodeTimeseriesStatistics(this.securityProvider.getTenantId(context), criteria, interval);
            log.tracef("Got business transaction node timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="node/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction node timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeTimeseriesStatistics(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval, @ApiParam(required=true, value="query criteria") NodeCriteria criteria) {
        try {
            log.tracef("Get business transaction node timeseries statistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            List stats = this.analyticsService.getNodeTimeseriesStatistics(this.securityProvider.getTenantId(context), criteria, interval);
            log.tracef("Got business transaction node timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="node/summary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction node summary statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeSummaryStatistics(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties) {
        try {
            NodeCriteria criteria = new NodeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get business transaction node summary statistics for criteria [%s]", (Object)criteria);
            List stats = this.analyticsService.getNodeSummaryStatistics(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got business transaction node summary statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="node/summary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the business transaction node summary statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeSummaryStatistics(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") NodeCriteria criteria) {
        try {
            log.tracef("Get business transaction node summary statistics for criteria [%s]", (Object)criteria);
            List stats = this.analyticsService.getNodeSummaryStatistics(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got business transaction node summary statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="hostnames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the host names associated with the criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getHostNames(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="business transactions after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="business transactions before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="business transactions with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties) {
        try {
            NodeCriteria criteria = new NodeCriteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get host names for criteria [%s]", (Object)criteria);
            List hostnames = this.analyticsService.getHostNames(this.securityProvider.getTenantId(context), (BaseCriteria)criteria);
            log.tracef("Got host names for criteria [%s] = %s", (Object)criteria, (Object)hostnames);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)hostnames).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="hostnames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the host names associated with the criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getHostNames(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") BaseCriteria criteria) {
        try {
            log.tracef("Get host names for criteria [%s]", (Object)criteria);
            List hostnames = this.analyticsService.getHostNames(this.securityProvider.getTenantId(context), criteria);
            log.tracef("Got host names for criteria [%s] = %s", (Object)criteria, (Object)hostnames);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)hostnames).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

