/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnSummary;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.server.api.security.SecurityProvider;
import org.jboss.logging.Logger;

@Path(value="config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="config", description="Configuration")
public class ConfigurationHandler {
    private static final Logger log = Logger.getLogger(ConfigurationHandler.class);
    @Inject
    SecurityProvider securityProvider;
    @Inject
    ConfigurationService configService;

    @GET
    @Path(value="collector")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the collector configuration for the optionally specified host and server", response=CollectorConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCollectorConfiguration(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="optional host name") @QueryParam(value="host") String host, @ApiParam(required=false, value="optional server name") @QueryParam(value="server") String server) {
        try {
            log.tracef("Get collector configuration for host [%s] server [%s]", (Object)host, (Object)server);
            CollectorConfiguration config = this.configService.getCollector(this.securityProvider.getTenantId(context), host, server);
            log.tracef("Got collector configuration for host [%s] server [%s] config=[%s]", (Object)host, (Object)server, (Object)config);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)config).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="businesstxn/summary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the business transaction summaries", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getBusinessTxnConfigurationSummaries(@Context SecurityContext context, @Suspended AsyncResponse response) {
        try {
            log.tracef("Get business transaction summaries", new Object[0]);
            List summaries = this.configService.getBusinessTransactionSummaries(this.securityProvider.getTenantId(context));
            Collections.sort(summaries, new Comparator<BusinessTxnSummary>(){

                @Override
                public int compare(BusinessTxnSummary arg0, BusinessTxnSummary arg1) {
                    if (arg0.getName() == null || arg1.getName() == null) {
                        return 0;
                    }
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
            log.tracef("Got business transaction summaries=[%s]", (Object)summaries);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)summaries).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="businesstxn/full")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the business transaction configurations, changed since an optional specified time", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getBusinessTxnConfigurations(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=false, value="updated since") @QueryParam(value="updated") @DefaultValue(value="0") long updated) {
        try {
            log.tracef("Get business transactions, updated = [%s]", updated);
            Map btxns = this.configService.getBusinessTransactions(this.securityProvider.getTenantId(context), updated);
            log.tracef("Got business transactions=[%s]", (Object)btxns);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)btxns).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="businesstxn/full/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the business transaction configuration for the specified name", response=BusinessTxnConfig.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getBusinessTxnConfiguration(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name) {
        try {
            log.tracef("Get business transaction configuration for name [%s]", (Object)name);
            BusinessTxnConfig config = this.configService.getBusinessTransaction(this.securityProvider.getTenantId(context), name);
            log.tracef("Got business transaction configuration for name [%s] config=[%s]", (Object)name, (Object)config);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)config).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @PUT
    @Path(value="businesstxn/full/{name}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Add or update the business transaction configuration for the specified name", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void setBusinessTxnConfiguration(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name, BusinessTxnConfig config) {
        try {
            log.tracef("About to set business transaction configuration for name [%s] config=[%s]", (Object)name, (Object)config);
            List messages = this.configService.updateBusinessTransaction(this.securityProvider.getTenantId(context), name, config);
            log.tracef("Updated business transaction configuration for name [%s] messages=[%s]", (Object)name, (Object)messages);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)messages).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).build());
        }
    }

    @DELETE
    @Path(value="businesstxn/full/{name}")
    @ApiOperation(value="Remove the business transaction configuration with the specified name")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void removeBusinessTxnConfiguration(@Context SecurityContext context, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name) {
        try {
            log.tracef("About to remove business transaction configuration for name [%s]", (Object)name);
            this.configService.removeBusinessTransaction(this.securityProvider.getTenantId(context), name);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).build());
        }
    }

    @POST
    @Path(value="businesstxn/validate")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Validate the business transaction configuration", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void validateBusinessTxnConfiguration(@Context SecurityContext context, @Suspended AsyncResponse response, BusinessTxnConfig config) {
        try {
            log.tracef("Validate business transaction configuration=[%s]", (Object)config);
            List messages = this.configService.validateBusinessTransaction(config);
            log.tracef("Validated business transaction configuration: messages=[%s]", (Object)messages);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)messages).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).build());
        }
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public void clear(@Context SecurityContext context, @Suspended AsyncResponse response) {
        try {
            if (System.getProperties().containsKey("hawkular-btm.testmode")) {
                this.configService.clear(this.securityProvider.getTenantId(context));
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                response.resume((Object)Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

