/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.rest;

import java.util.Set;
import java.util.StringTokenizer;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.services.Criteria;
import org.jboss.logging.Logger;

public class RESTServiceUtil {
    private static final Logger log = Logger.getLogger(RESTServiceUtil.class);

    public static void decodeProperties(Set<Criteria.PropertyCriteria> properties, String encoded) {
        if (encoded != null && encoded.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] parts = token.split("[|]");
                if (parts.length != 2) continue;
                String name = parts[0].trim();
                String value = parts[1].trim();
                boolean excluded = false;
                if (name.length() > 0 && name.charAt(0) == '-') {
                    name = name.substring(1);
                    excluded = true;
                }
                log.tracef("Extracted property name [%s] value [%s] excluded [%s]", (Object)name, (Object)value, (Object)excluded);
                properties.add(new Criteria.PropertyCriteria(name, value, excluded));
            }
        }
    }

    public static void decodeCorrelationIdentifiers(Set<CorrelationIdentifier> correlations, String encoded) {
        if (encoded != null && encoded.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] parts = token.split("[|]");
                if (parts.length != 2) continue;
                String scope = parts[0].trim();
                String value = parts[1].trim();
                log.tracef("Extracted correlation identifier scope [%s] value [%s]", (Object)scope, (Object)value);
                CorrelationIdentifier cid = new CorrelationIdentifier();
                cid.setScope(CorrelationIdentifier.Scope.valueOf((String)scope));
                cid.setValue(value);
                correlations.add(cid);
            }
        }
    }

    public static void decodeFaults(Set<Criteria.FaultCriteria> faults, String encoded) {
        if (encoded != null && encoded.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String fault = st.nextToken();
                boolean excluded = false;
                if (fault.length() > 0 && fault.charAt(0) == '-') {
                    fault = fault.substring(1);
                    excluded = true;
                }
                log.tracef("Extracted fault [%s] excluded [%s]", (Object)fault, (Object)excluded);
                faults.add(new Criteria.FaultCriteria(fault, excluded));
            }
        }
    }
}

