/// Copyright 2014-2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///   http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.

/// <reference path="btmPlugin.ts"/>
module BTM {

  export var BTMCandidatesController = _module.controller("BTM.BTMCandidatesController", ["$scope", "$http", '$location', '$uibModal', '$interval', ($scope, $http, $location, $uibModal, $interval) => {

    $scope.newBTxnName = '';
    $scope.existingBTxnName = '';
    $scope.selecteduris = [ ];
    $scope.candidateCount = 0;

    $http.get('/hawkular/btm/config/businesstxnsummary').then(function(resp) {
      $scope.businessTransactions = resp.data;
    },function(resp) {
      console.log("Failed to get business txn summaries: "+resp);
    });

    $scope.reload = function() {
      $http.get('/hawkular/btm/analytics/businesstxn/unbounduris').then(function(resp) {
        $scope.unbounduris = resp.data;
        $scope.candidateCount = Object.keys(resp.data).length;
      },function(resp) {
        console.log("Failed to get unbound URIs: "+resp);
      });
    };

    $scope.reload();

    $interval(function() {
      $scope.reload();
    },10000);

    $scope.addBusinessTxn = function() {
      var defn = {
        filter: {
          inclusions: $scope.selecteduris
        }
      };
      $http.put('/hawkular/btm/config/businesstxn/'+$scope.newBTxnName, defn).then(function(resp) {
        $location.path('config/'+$scope.newBTxnName);
      },function(resp) {
        console.log("Failed to add business txn '"+$scope.newBTxnName+"': "+resp);
      });
    };

    $scope.ignoreBusinessTxn = function() {
      var defn = {
        level: 'Ignore',
        filter: {
          inclusions: $scope.selecteduris
        }
      };
      $http.put('/hawkular/btm/config/businesstxn/'+$scope.newBTxnName, defn).then(function(resp) {
        $location.path('config/'+$scope.newBTxnName);
      },function(resp) {
        console.log("Failed to ignore business txn '"+$scope.newBTxnName+"': "+resp);
      });
    };

    $scope.updateBusinessTxn = function() {
      $http.get('/hawkular/btm/config/businesstxn/'+$scope.existingBTxnName).then(function(resp) {
        var btxn = resp.data;
        for (var i = 0; i < $scope.selecteduris.length; i++) {
          if (btxn.filter.inclusions.indexOf($scope.selecteduris[i]) === -1) {
            btxn.filter.inclusions.add($scope.selecteduris[i]);
          }
        }
        $http.put('/hawkular/btm/config/businesstxn/'+$scope.existingBTxnName,btxn).then(function(resp) {
          console.log("Saved updated business txn '"+$scope.existingBTxnName+"': "+resp);
          $location.path('config/'+$scope.existingBTxnName);
        },function(resp) {
          console.log("Failed to save business txn '"+$scope.existingBTxnName+"': "+resp);
        });
      },function(resp) {
        console.log("Failed to get business txn '"+$scope.existingBTxnName+"': "+resp);
      });
    };

    $scope.selectionChanged = function(uri) {
      var regex = $scope.escapeRegExp(uri);
      if ($scope.selecteduris.contains(regex)) {
        $scope.selecteduris.remove(regex);
      } else {
        $scope.selecteduris.add(regex);
      }
    };
    
    $scope.isSelected = function(uri) {
      var regex = $scope.escapeRegExp(uri);
      return $scope.selecteduris.contains(regex);
    };
    
    $scope.getLevel = function(level) {
      if (level === 'All') {
        return "Active";
      }
      return level;
    };

    $scope.escapeRegExp = function(str) {
      return "^" + str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&") + "$";
    };

  }]);

}

