/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.broker.extension;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hawkular.bus.broker.EmbeddedBroker;
import org.hawkular.bus.broker.extension.BrokerConfigurationSetup;
import org.hawkular.bus.broker.extension.log.MsgLogger;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class BrokerService
implements Service<BrokerService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"org.hawkular.bus"}).append(new String[]{"hawkular-bus-broker"});
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BrokerService.class);
    final InjectedValue<ServerEnvironment> envServiceValue = new InjectedValue();
    final InjectedValue<SocketBinding> connectorSocketBinding = new InjectedValue();
    final InjectedValue<SocketBinding> discoverySocketBinding = new InjectedValue();
    private String configurationFile;
    private Map<String, String> customConfigProperties = Collections.synchronizedMap(new HashMap());
    private AtomicReference<EmbeddedBroker> theBroker = new AtomicReference();
    private Thread brokerThread;

    public BrokerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.msglog.infoBrokerServiceStarting();
        this.startBroker();
        this.msglog.infoBrokerServiceStarted();
    }

    public void stop(StopContext context) {
        this.msglog.infoBrokerServiceStopping();
        this.stopBroker();
        this.msglog.infoBrokerServiceStopped();
    }

    protected void setConfigurationFile(String configFile) {
        this.configurationFile = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCustomConfigurationProperties(Map<String, String> properties) {
        Map<String, String> map = this.customConfigProperties;
        synchronized (map) {
            this.customConfigProperties.clear();
            if (properties != null) {
                this.customConfigProperties.putAll(properties);
            }
        }
    }

    public boolean isBrokerStarted() {
        EmbeddedBroker broker = this.theBroker.get();
        return broker != null && broker.isBrokerStarted();
    }

    public String getBrokerName() {
        return this.customConfigProperties.get("org.hawkular.bus.broker.name");
    }

    protected void startBroker() throws StartException {
        if (this.isBrokerStarted()) {
            this.msglog.infoBrokerAlreadyStarted();
            return;
        }
        this.msglog.infoStartingBrokerNow();
        try {
            SocketBinding connectorSocketBindingValue = (SocketBinding)this.connectorSocketBinding.getValue();
            String connectorAddress = connectorSocketBindingValue.getAddress().getHostAddress();
            String connectorPort = String.valueOf(connectorSocketBindingValue.getAbsolutePort());
            if (connectorAddress.equals("0.0.0.0") || connectorAddress.equals("::/128")) {
                connectorAddress = InetAddress.getLocalHost().getCanonicalHostName();
            }
            this.customConfigProperties.put("org.hawkular.bus.broker.connector.address", connectorAddress);
            this.customConfigProperties.put("org.hawkular.bus.broker.connector.port", connectorPort);
            this.msglog.infoBrokerBindingToSocket(connectorAddress, connectorPort);
            SocketBinding discoverySocketBindingValue = (SocketBinding)this.discoverySocketBinding.getValue();
            String discoveryAddress = discoverySocketBindingValue.getMulticastAddress().getHostAddress();
            String discoveryPort = String.valueOf(discoverySocketBindingValue.getMulticastPort());
            this.customConfigProperties.put("org.hawkular.bus.broker.discovery.address", discoveryAddress);
            this.customConfigProperties.put("org.hawkular.bus.broker.discovery.port", discoveryPort);
            this.msglog.infoBrokerDiscoveryEndpoint(discoveryAddress, discoveryPort);
            ServerEnvironment env = (ServerEnvironment)this.envServiceValue.getValue();
            BrokerConfigurationSetup configSetup = new BrokerConfigurationSetup(this.configurationFile, this.customConfigProperties, env);
            this.msglog.infoBrokerConfigurationFile(configSetup.getConfigurationFile());
            Map<String, String> customConfig = configSetup.getCustomConfiguration();
            String[] args = new String[2 * customConfig.size() + 2];
            int argIndex = 0;
            for (Map.Entry<String, String> entry : customConfig.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                args[argIndex++] = "-D";
                args[argIndex++] = name + "=" + value;
            }
            args[argIndex++] = "-c";
            args[argIndex++] = configSetup.getConfigurationFile();
            this.theBroker.set(new EmbeddedBroker(args));
            this.brokerThread = new Thread("Broker Start Thread"){

                @Override
                public void run() {
                    try {
                        ((EmbeddedBroker)BrokerService.this.theBroker.get()).startBroker();
                    }
                    catch (InterruptedException e) {
                        BrokerService.this.log.debug((Object)"Broker has exited.");
                    }
                    catch (Throwable t) {
                        BrokerService.this.msglog.errorBrokerAborted(t);
                    }
                }
            };
            this.brokerThread.setDaemon(true);
            this.brokerThread.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    protected void stopBroker() {
        try {
            if (!this.isBrokerStarted()) {
                this.msglog.infoBrokerAlreadyStopped();
            } else {
                this.msglog.infoStoppingBrokerNow();
                this.theBroker.get().stopBroker();
            }
        }
        catch (Throwable t) {
            this.msglog.errorFailedToShutdownBroker(t);
        }
        finally {
            if (this.brokerThread != null) {
                this.brokerThread.interrupt();
            }
        }
        this.theBroker.set(null);
    }
}

