/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.broker.extension;

import java.io.File;
import java.util.Map;
import org.hawkular.bus.broker.extension.log.MsgLogger;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.Resource;
import org.jboss.util.StringPropertyReplacer;

public class BrokerConfigurationSetup {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BrokerConfigurationSetup.class);
    private final String configurationFile;
    private final Map<String, String> customConfiguration;
    private final ServerEnvironment serverEnvironment;

    public BrokerConfigurationSetup(String configFile, Map<String, String> customConfigProps, ServerEnvironment serverEnv) {
        if (configFile == null || configFile.trim().isEmpty()) {
            configFile = "default-broker.xml";
        }
        this.customConfiguration = customConfigProps;
        this.serverEnvironment = serverEnv;
        this.configurationFile = this.getUsableConfigurationFilePath(configFile, serverEnv);
        this.prepareConfiguration();
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public Map<String, String> getCustomConfiguration() {
        return this.customConfiguration;
    }

    public ServerEnvironment getServerEnvironment() {
        return this.serverEnvironment;
    }

    private void prepareConfiguration() {
        Map<String, String> customConfigProps = this.customConfiguration;
        this.prepareConfigurationProperty(customConfigProps, "org-hawkular-bus-broker-name", "org.hawkular.bus.broker");
        this.prepareConfigurationProperty(customConfigProps, "org-hawkular-bus-broker-persistent", Boolean.toString(false));
        this.prepareConfigurationProperty(customConfigProps, "org-hawkular-bus-broker-use-jmx", Boolean.toString(false));
        this.prepareConfigurationProperty(customConfigProps, "org-hawkular-bus-broker-connector-name", "openwire");
        this.prepareConfigurationProperty(customConfigProps, "org-hawkular-bus-broker-connector-protocol", "tcp");
        for (Map.Entry<String, String> entry : customConfigProps.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            entry.setValue(StringPropertyReplacer.replaceProperties((String)value));
        }
    }

    private void prepareConfigurationProperty(Map<String, String> customConfigProps, String prop, String defaultValue) {
        String propValue = customConfigProps.get(prop);
        if (propValue == null || propValue.trim().length() == 0 || "-".equals(propValue)) {
            this.log.debugf("Broker configuration property [%s] was undefined; will default to [%s]", (Object)prop, (Object)defaultValue);
            customConfigProps.put(prop, defaultValue);
        }
    }

    private String getUsableConfigurationFilePath(String configFile, ServerEnvironment serverEnv) {
        File file = new File(configFile);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        File serverConfigDir = serverEnv.getServerConfigurationDir();
        File configFileInServerConfigDir = new File(serverConfigDir, configFile);
        if (configFileInServerConfigDir.exists()) {
            return configFileInServerConfigDir.getAbsolutePath();
        }
        try {
            Module module = Module.forClass(this.getClass());
            Resource r = module.getExportedResource("config", configFile);
            return r.getURL().toString();
        }
        catch (Throwable t) {
            this.msglog.warnCannotDetermineConfigFilePath(configFile, t.toString());
            return configFile;
        }
    }
}

