/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.broker.extension;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.hawkular.bus.broker.extension.BrokerSubsystemDefinition;
import org.hawkular.bus.broker.extension.log.MsgLogger;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class BrokerSubsystemExtension
implements Extension {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BrokerSubsystemExtension.class);
    public static final String NAMESPACE = "urn:org.hawkular.bus:broker:1.0";
    public static final String SUBSYSTEM_NAME = "hawkular-bus-broker";
    public static final String DEPLOYMENT_REST_WAR = "rest.war";
    private final SubsystemParser parser = new SubsystemParser();
    private static final String RESOURCE_NAME = BrokerSubsystemExtension.class.getPackage().getName() + ".LocalDescriptions";
    protected static final String BROKER_NAME_SYSPROP = "org-hawkular-bus-broker-name";
    protected static final String BROKER_PERSISTENT_SYSPROP = "org-hawkular-bus-broker-persistent";
    protected static final String BROKER_USE_JMX_SYSPROP = "org-hawkular-bus-broker-use-jmx";
    protected static final String BROKER_CONNECTOR_NAME_SYSPROP = "org-hawkular-bus-broker-connector-name";
    protected static final String BROKER_CONNECTOR_PROTOCOL_SYSPROP = "org-hawkular-bus-broker-connector-protocol";
    protected static final String BROKER_CONNECTOR_ADDRESS_SYSPROP = "org-hawkular-bus-broker-connector-address";
    protected static final String BROKER_CONNECTOR_PORT_SYSPROP = "org-hawkular-bus-broker-connector-port";
    protected static final String BROKER_DISCOVERY_ADDRESS_SYSPROP = "org-hawkular-bus-broker-discovery-address";
    protected static final String BROKER_DISCOVERY_PORT_SYSPROP = "org-hawkular-bus-broker-discovery-port";
    protected static final String BROKER_ENABLED_ATTR = "enabled";
    protected static final boolean BROKER_ENABLED_DEFAULT = false;
    protected static final String BROKER_CONFIG_FILE_ATTR = "configuration-file";
    protected static final String BROKER_CONFIG_FILE_DEFAULT = "default-broker.xml";
    protected static final String BROKER_NAME_ELEMENT = "org-hawkular-bus-broker-name";
    protected static final String BROKER_NAME_DEFAULT = "org.hawkular.bus.broker";
    protected static final String PERSISTENT_ELEMENT = "org-hawkular-bus-broker-persistent";
    protected static final boolean PERSISTENT_DEFAULT = false;
    protected static final String USE_JMX_ELEMENT = "org-hawkular-bus-broker-use-jmx";
    protected static final boolean USE_JMX_DEFAULT = false;
    protected static final String CONNECTOR_ELEMENT = "connector";
    protected static final String CONNECTOR_NAME_ATTR = "org-hawkular-bus-broker-connector-name";
    protected static final String CONNECTOR_PROTOCOL_ATTR = "org-hawkular-bus-broker-connector-protocol";
    protected static final String CONNECTOR_SOCKET_BINDING_ATTR = "socket-binding";
    protected static final String CONNECTOR_SOCKET_BINDING_DEFAULT = "org.hawkular.bus.broker";
    protected static final String CONNECTOR_NAME_DEFAULT = "openwire";
    protected static final String CONNECTOR_PROTOCOL_DEFAULT = "tcp";
    protected static final String DISCOVERY_SOCKET_BINDING_ELEMENT = "discovery-socket-binding";
    protected static final String DISCOVERY_SOCKET_BINDING_DEFAULT = "org.hawkular.bus.broker.discovery";
    protected static final String CUSTOM_CONFIG_ELEMENT = "custom-configuration";
    protected static final String PROPERTY_ELEMENT = "property";
    protected static final String BROKER_START_OP = "start";
    protected static final String BROKER_STOP_OP = "stop";
    protected static final String BROKER_STATUS_OP = "status";
    protected static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"hawkular-bus-broker");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, BrokerSubsystemExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        this.msglog.infoInitializingBrokerSubsystem();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)BrokerSubsystemDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)this.parser);
    }

    private static class SubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private SubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            String brokerConfigFileValue;
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{BrokerSubsystemExtension.BROKER_ENABLED_ATTR});
            ModelNode opAdd = new ModelNode();
            opAdd.get("operation").set("add");
            opAdd.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{SUBSYSTEM_PATH}).toModelNode());
            String brokerEnabledValue = reader.getAttributeValue(null, BrokerSubsystemExtension.BROKER_ENABLED_ATTR);
            if (brokerEnabledValue != null) {
                opAdd.get(BrokerSubsystemExtension.BROKER_ENABLED_ATTR).set(new ValueExpression(brokerEnabledValue));
            }
            if ((brokerConfigFileValue = reader.getAttributeValue(null, BrokerSubsystemExtension.BROKER_CONFIG_FILE_ATTR)) != null) {
                opAdd.get(BrokerSubsystemExtension.BROKER_CONFIG_FILE_ATTR).set(new ValueExpression(brokerConfigFileValue));
            }
            while (reader.hasNext() && reader.nextTag() != 2) {
                String elementName = reader.getLocalName();
                if (elementName.equals(BrokerSubsystemExtension.CUSTOM_CONFIG_ELEMENT)) {
                    ModelNode configAttributeNode = opAdd.get(BrokerSubsystemExtension.CUSTOM_CONFIG_ELEMENT);
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        if (!reader.isStartElement()) continue;
                        this.readCustomConfigurationProperty(reader, configAttributeNode);
                    }
                    continue;
                }
                if (elementName.equals(BrokerSubsystemExtension.CONNECTOR_ELEMENT)) {
                    String val = reader.getAttributeValue(null, "org-hawkular-bus-broker-connector-name");
                    if (val != null) {
                        opAdd.get("org-hawkular-bus-broker-connector-name").set(new ValueExpression(val));
                    }
                    if ((val = reader.getAttributeValue(null, "org-hawkular-bus-broker-connector-protocol")) != null) {
                        opAdd.get("org-hawkular-bus-broker-connector-protocol").set(new ValueExpression(val));
                    }
                    if ((val = reader.getAttributeValue(null, BrokerSubsystemExtension.CONNECTOR_SOCKET_BINDING_ATTR)) != null) {
                        opAdd.get(BrokerSubsystemExtension.CONNECTOR_SOCKET_BINDING_ATTR).set(val);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue;
                }
                if (elementName.equals("org-hawkular-bus-broker-name")) {
                    opAdd.get("org-hawkular-bus-broker-name").set(new ValueExpression(reader.getElementText()));
                    continue;
                }
                if (elementName.equals("org-hawkular-bus-broker-persistent")) {
                    opAdd.get("org-hawkular-bus-broker-persistent").set(new ValueExpression(reader.getElementText()));
                    continue;
                }
                if (elementName.equals("org-hawkular-bus-broker-use-jmx")) {
                    opAdd.get("org-hawkular-bus-broker-use-jmx").set(new ValueExpression(reader.getElementText()));
                    continue;
                }
                if (elementName.equals(BrokerSubsystemExtension.DISCOVERY_SOCKET_BINDING_ELEMENT)) {
                    opAdd.get(BrokerSubsystemExtension.DISCOVERY_SOCKET_BINDING_ELEMENT).set(reader.getElementText());
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            list.add(opAdd);
        }

        private void readCustomConfigurationProperty(XMLExtendedStreamReader reader, ModelNode configAttributeNode) throws XMLStreamException {
            if (!reader.getLocalName().equals(BrokerSubsystemExtension.PROPERTY_ELEMENT)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
            String attr = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
            String val = reader.getAttributeValue(null, Attribute.VALUE.getLocalName());
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            configAttributeNode.add(attr, val);
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            context.startSubsystemElement(BrokerSubsystemExtension.NAMESPACE, false);
            writer.writeAttribute(BrokerSubsystemExtension.BROKER_ENABLED_ATTR, node.get(BrokerSubsystemExtension.BROKER_ENABLED_ATTR).asString());
            writer.writeAttribute(BrokerSubsystemExtension.BROKER_CONFIG_FILE_ATTR, node.get(BrokerSubsystemExtension.BROKER_CONFIG_FILE_ATTR).asString());
            this.writeElement(writer, node, "org-hawkular-bus-broker-name");
            this.writeElement(writer, node, "org-hawkular-bus-broker-persistent");
            this.writeElement(writer, node, "org-hawkular-bus-broker-use-jmx");
            writer.writeStartElement(BrokerSubsystemExtension.CONNECTOR_ELEMENT);
            ModelNode connectorNameNode = node.get("org-hawkular-bus-broker-connector-name");
            ModelNode connectorProtocolNode = node.get("org-hawkular-bus-broker-connector-protocol");
            ModelNode connectorSocketBindingNode = node.get(BrokerSubsystemExtension.CONNECTOR_SOCKET_BINDING_ATTR);
            if (connectorNameNode.isDefined()) {
                writer.writeAttribute("org-hawkular-bus-broker-connector-name", connectorNameNode.asString());
            }
            if (connectorProtocolNode.isDefined()) {
                writer.writeAttribute("org-hawkular-bus-broker-connector-protocol", connectorProtocolNode.asString());
            }
            if (connectorSocketBindingNode.isDefined()) {
                writer.writeAttribute(BrokerSubsystemExtension.CONNECTOR_SOCKET_BINDING_ATTR, connectorSocketBindingNode.asString());
            }
            writer.writeEndElement();
            this.writeElement(writer, node, BrokerSubsystemExtension.DISCOVERY_SOCKET_BINDING_ELEMENT);
            writer.writeStartElement(BrokerSubsystemExtension.CUSTOM_CONFIG_ELEMENT);
            ModelNode configNode = node.get(BrokerSubsystemExtension.CUSTOM_CONFIG_ELEMENT);
            if (configNode != null && configNode.isDefined()) {
                for (Property property : configNode.asPropertyList()) {
                    writer.writeStartElement(BrokerSubsystemExtension.PROPERTY_ELEMENT);
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), property.getValue().asString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeElement(XMLExtendedStreamWriter writer, ModelNode node, String attribName) throws XMLStreamException {
            ModelNode attribNode = node.get(attribName);
            if (attribNode.isDefined()) {
                writer.writeStartElement(attribName);
                writer.writeCharacters(attribNode.asString());
                writer.writeEndElement();
            }
        }
    }
}

