/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.bus.common.MessageId;

public abstract class BasicMessage {
    private MessageId _messageId;
    private MessageId _correlationId;
    private Map<String, String> _headers;

    public static <T extends BasicMessage> T fromJSON(String json, Class<T> clazz) {
        Gson gson = BasicMessage.createGsonBuilder();
        return (T)((BasicMessage)gson.fromJson(json, clazz));
    }

    public String toJSON() {
        Gson gson = BasicMessage.createGsonBuilder();
        return gson.toJson((Object)this);
    }

    protected BasicMessage() {
    }

    public MessageId getMessageId() {
        return this._messageId;
    }

    public void setMessageId(MessageId messageId) {
        this._messageId = messageId;
    }

    public MessageId getCorrelationId() {
        return this._correlationId;
    }

    public void setCorrelationId(MessageId correlationId) {
        this._correlationId = correlationId;
    }

    public Map<String, String> getHeaders() {
        if (this._headers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._headers);
    }

    public void setHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            this._headers = null;
        } else if (this._headers == null) {
            this._headers = new HashMap<String, String>(headers);
        } else {
            this._headers.clear();
            this._headers.putAll(headers);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName() + ": [");
        str.append("message-id=");
        str.append(this.getMessageId());
        str.append(", correlation-id=");
        str.append(this.getCorrelationId());
        str.append(", headers=");
        str.append(this.getHeaders());
        str.append(", json-body=[");
        str.append(this.toJSON());
        str.append("]]");
        return str.toString();
    }

    protected static Gson createGsonBuilder() {
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    }
}

